#import <Foundation/Foundation.h>


@interface NSAppleEventDescriptor (PCAdditions)

+ (NSAppleEventDescriptor*)pc_descriptorWithApplicationBundleID:(NSString*)bundleID;
+ (NSAppleEventDescriptor*)pc_descriptorWithFileURL:(NSURL*)fileURL;

+ (NSAppleEventDescriptor*)pc_descriptorWithObjectSpecifierClass:(DescType)desiredClass container:(NSAppleEventDescriptor*)theContainer keyForm:(DescType)keyForm keyData:(NSAppleEventDescriptor*)keyData;

// pass NULL for |outReply| to send without reply (kAENoReply), waiting otherwise (kAEWaitReply) with default timeout
- (BOOL)pc_sendAndGetReply:(NSAppleEventDescriptor**)outReply error:(NSError**)outError;
// |timeout| still accepts kAEDefaultTimeout and kNoTimeOut
- (BOOL)pc_sendAndGetReply:(NSAppleEventDescriptor**)outReply sendMode:(AESendMode)sendMode timeout:(NSTimeInterval)timeout error:(NSError**)outError;

// send a kAECoreSuite/kAEGetData event to target with property as direct object
- (NSAppleEventDescriptor*)pc_descriptorForProperty:(NSAppleEventDescriptor*)property targetDescriptor:(NSAppleEventDescriptor*)targetDescriptor error:(NSError**)outError;

@end
