#import <Cocoa/Cocoa.h>


@interface NSAttributedString (Images)

+ (NSAttributedString*)pc_attributedStringWithImage:(NSImage*)image baselineOffset:(float)baselineOffset;
+ (NSAttributedString*)pc_attributedStringWithImage:(NSImage*)image attributes:(NSDictionary*)attributes baselineOffset:(float)baselineOffset;
+ (NSAttributedString*)pc_attributedStringWithFileWrapper:(NSFileWrapper*)wrapper attributes:(NSDictionary*)attributes baselineOffset:(float)baselineOffset;
+ (NSAttributedString*)pc_attributedStringWithAttachmentAtPath:(NSString*)path attributes:(NSDictionary*)attributes baselineOffset:(float)baselineOffset;

- (NSAttributedString*)pc_attributedStringByAppendingImage:(NSImage*)image baselineOffset:(float)baselineOffset;

@end


@interface NSMutableAttributedString (Images)

- (void)pc_insertImage:(NSImage*)image atIndex:(NSUInteger)index baselineOffset:(float)baselineOffset;
- (void)pc_appendImage:(NSImage*)image baselineOffset:(float)offset;
- (void)pc_appendAttachmentAtPath:(NSString*)url baselineOffset:(float)offset;

@end