/*
 *  NSData-Compare.h
 *
 *  Requires Mac OS X 10.0 or higher
 *
 *	Provides a category for easily comparing data blobs.
 *
 *	-------------------------------------------------------------------
 *
 *
 */

#import <Foundation/Foundation.h>


@interface NSData (PCCompare)

- (BOOL)pc_hasPrefix:(NSData*)prefix;
- (BOOL)pc_hasSuffix:(NSData*)suffix;

typedef NSUInteger PCDataSearchOptions;
enum {
	PCDataSearchBackwards = 1UL << 0,
	PCDataSearchAnchored = 1UL << 1
};

- (NSRange)pc_rangeOfData:(NSData*)dataToFind options:(PCDataSearchOptions)mask range:(NSRange)searchRange;

@end
