#import <Cocoa/Cocoa.h>


@interface NSEvent (PCCommonKeys)

- (NSUInteger)pc_regularModifierFlags; // gives back only the common keyboard modifier flags

- (BOOL)pc_isCommandPeriod;
- (BOOL)pc_isEnter;
- (BOOL)pc_isReturn;
- (BOOL)pc_isReturnOrEnter;
- (BOOL)pc_isEscape;
- (BOOL)pc_isCommandReturn;

- (BOOL)pc_isTab;
- (BOOL)pc_isShiftTab;
- (BOOL)pc_isSpacebar;

- (BOOL)pc_isDelete;
- (BOOL)pc_isDeleteOrForwardDelete;
- (BOOL)pc_isForwardDelete;
- (BOOL)pc_isCommandDelete;

- (BOOL)pc_isCommandDownArrow;
- (BOOL)pc_isCommandUpArrow;
- (BOOL)pc_isRightArrow;
- (BOOL)pc_isLeftArrow;
- (BOOL)pc_isUpArrow;
- (BOOL)pc_isDownArrow;

- (BOOL)pc_isHome;
- (BOOL)pc_isEnd;

- (BOOL)pc_hasShiftModifierOnly;
- (BOOL)pc_hasCommandModifierOnly;
- (BOOL)pc_hasOptionModifierOnly;
- (BOOL)pc_hasControlModifierOnly;

- (BOOL)pc_isKeyDown:(unichar)key withModifierFlags:(NSUInteger)modifier;

- (BOOL)pc_isFirstCharacter:(unichar)character;

@end
