#import <Foundation/Foundation.h>


@interface NSFileManager (PCDirectoryInspection)

- (NSUInteger)pc_numberOfFilesAtPath:(NSString*)path;
- (unsigned long long)pc_sizeOfFolderContentsAtPath:(NSString*)path physicalSize:(unsigned long long*)outPhysicalSize;

- (NSArray*)pc_deepDirectoryContentsAtPath:(NSString*)path; // Calls pc_deepDirectoryContentsAtPath:path includeHidden:NO includeDirectories:YES conformsToUTI:nil

- (NSArray*)pc_deepDirectoryContentsAtPath:(NSString*)path 
						  includeHidden:(BOOL)includeHidden 		
					 includeDirectories:(BOOL)includeDirectories 	// If NO, then directories are not included in the ouput array
						  conformsToUTI:(NSString*)inUTI;

- (NSArray*)pc_deepDirectoryContentsAtPath:(NSString*)path 
						  includeHidden:(BOOL)includeHidden 		
					 includeDirectories:(BOOL)includeDirectories 	// If NO, then directories are not included in the ouput array
						  conformsToUTI:(NSString*)inUTI 			// Pass in nil to not filter based on file UTI
						  excludesFiles:(NSArray*)excludedFiles;

- (NSArray*)pc_deepDirectoryContentsAtPath:(NSString*)path
						  includeHidden:(BOOL)includeHidden 
					 includeDirectories:(BOOL)includeDirectories	// If NO, then directories are not included in the ouput array 
						  excludingUTIs:(NSArray*)inUTIs;			// Pass in nil to not filter based on file UTI

- (NSArray*)pc_deepDirectoryContentsAtPath:(NSString*)path
						  includeHidden:(BOOL)includeHidden 
					 includeDirectories:(BOOL)includeDirectories	// If NO, then directories are not included in the ouput array 
						  excludingUTIs:(NSArray*)inUTIs			// Pass in nil to not filter based on file UTI
						  excludesFiles:(NSArray*)excludedFiles;

- (BOOL)pc_removeDirectoryContentsAtPath:(NSString*)path handler:(id)handler;

@end
