#import <AppKit/AppKit.h>


@interface NSImage (PCAdditions)

// creation methods

- (CGImageRef)pc_CGImage;
- (NSBitmapImageRep*)pc_bitmapImageRep;
- (CIImage*)pc_CIImage;
- (CGLayerRef)pc_CGLayer;
- (CGLayerRef)pc_CGLayerWithAlpha:(CGFloat)alpha;

// general methods

+ (NSImage*)pc_dragImageWithBadgeForCount:(NSUInteger)count baseImage:(NSImage*)baseImage offset:(NSPointPointer)dragImageOffset; // constructs a red-badged custom drag image for multi-item drags or nil if a badged image is inappropriate for the requested count

+ (NSImage*)pc_templateImageNamed:(NSString*)name;
+ (NSImage*)pc_templateImageNamed:(NSString*)name size:(NSSize)size;

- (void)pc_setTemplateIfSupported;
- (NSImage*)pc_whiteTemplateImage;
- (NSImage*)pc_blueTemplateImage;
- (NSImage*)pc_templateImageWithGradient:(NSGradient*)fillGradient glow:(BOOL)glow;

+ (NSImage*)pc_resultsImageForCount:(NSUInteger)count backgroundColor:(NSColor*)backgroundColor foregroundColor:(NSColor*)foregroundColor;
+ (NSImage*)pc_systemIcon:(OSType)type withSize:(NSSize)size;

- (NSImage*)pc_imageByScalingProportionallyDownToSize:(NSSize)newSize; // won't scale images up
- (NSImage*)pc_copyWithSize:(NSSize)size usingInterpolation:(NSImageInterpolation)interpolation;
- (NSImage*)pc_copyWithSize:(NSSize)size;

- (NSImage*)pc_copyAsBitmapWithSize:(NSSize)size usingInterpolation:(NSImageInterpolation)interpolation;
- (NSImage*)pc_copyAsBitmapWithSize:(NSSize)size;
- (NSImage*)pc_copyAsBitmap;
- (BOOL)pc_isPDF;

- (NSImageRep*)pc_repBestMatchingSize:(NSSize)repSize;

- (NSSize)pc_pixelSize;

- (void)pc_drawFlippedInRect:(NSRect)dstRect fromRect:(NSRect)srcRect operation:(NSCompositingOperation)op fraction:(CGFloat)delta;
- (void)pc_drawFlippedInRect:(NSRect)dstRect;

- (void)pc_drawFlippedInRect:(NSRect)rect inView:(NSView*)aView operation:(NSCompositingOperation)op fraction:(CGFloat)delta;
- (void)pc_drawFlippedInRect:(NSRect)rect inView:(NSView*)aView;

- (void)pc_drawFlippedHorizontallyInRect:(NSRect)dstRect fromRect:(NSRect)srcRect operation:(NSCompositingOperation)op fraction:(CGFloat)delta;
- (void)pc_drawFlippedHorizontallyInRect:(NSRect)dstRect;

- (NSImage*)pc_imageByTintingWithColor:(NSColor*)aColor;

- (NSImage*)pc_imageWithAlpha:(CGFloat)alpha;

- (NSImage*)pc_compositeImageCentered:(NSImage*)badge;
- (NSImage*)pc_resizeUsingNinePartsToSize:(NSSize)newSize;

- (NSImage*)pc_grayscale;

@end
