/*
 *  NSPasteboard-Arrays.h
 *
 *  Requires Mac OS X 10.0 or higher
 *
 *	Provides a mechanism for setting arbitrary arrays to the pasteboard,
 *  which can very useful for drag and drop support.
 *
 */

#import <Cocoa/Cocoa.h>

@interface NSPasteboard (PCArrays)

- (NSArray*)pc_arrayForType:(NSString*)pboardType;
- (NSArray*)pc_arrayForTypeClearWhenDone:(NSString*)pboardType;
- (BOOL)pc_setArray:(NSArray*)arrayData forType:(NSString*)pbaordType;

- (BOOL)pc_writeObjects:(NSArray*)objects;

@end
