#import <Foundation/Foundation.h>


@interface NSString (PCFileUtilities)

// Creates an FSRef for the file whose path is in this string. If the file doesn't exist and createFile is set, this method will attempt to create an empty file with the specified path. The caller is responsible for ensuring that the directory in which the file is to be placed already exists. Leaf symlinks are followed by default.
- (BOOL)pc_getFSRef:(FSRef*)fsRef createFileIfNecessary:(BOOL)createFile;
- (BOOL)pc_getFSRef:(FSRef*)fsRef createFileIfNecessary:(BOOL)createFile followLeafSymlink:(BOOL)follow;

// Creates an FSSpec for the file whose path is in this string. If the file doesn't exist and createFile is set, this method will attempt to create an empty file with the specified path. The caller is responsible for ensuring that the directory in which the file is to be placed already exists.
- (BOOL)pc_getFSSpec:(FSSpec*)fsSpec createFileIfNecessary:(BOOL)createFile;

+ (NSString*)pc_filenameFromHFSUniStr255:(const HFSUniStr255*)uniStr;
+ (NSString*)pc_filenameFromFSRef:(const FSRef*)fsRef; // canonical case according to file system
+ (NSString*)pc_pathFromFSRef:(const FSRef*)fsRef; // canonical case according to file system

- (NSString*)pc_pathByValidatingCase; // Returns the canonical case of the path according to the file system

@end
