#import <Foundation/Foundation.h>


@interface NSString (PathAdditions)

NSString* PCHomeDirectory();

- (NSString*)pc_commonPathPrefix:(NSString*)path;
- (NSString*)pc_commonPathPrefix:(NSString*)aPath options:(NSStringCompareOptions)options;
- (BOOL)pc_hasCompletePathPrefix;
- (BOOL)pc_isFileExtensionHidden;
- (BOOL)pc_isFileVisible;
- (BOOL)pc_isChildOfPath:(NSString*)aPath;
- (NSString*)pc_stringByNormalizingPath;
- (NSString*)pc_stringByStandardizingUnixPath;
- (NSString*)pc_stringByRebasingPathFromRoot:(NSString*)fromRoot toRoot:(NSString*)toRoot; // was: - (NSString*)pathAtRoot:(NSString*)oldRoot relativeToAlternateRoot:(NSString*)newRoot;
- (BOOL)pc_setFileExtensionHidden:(BOOL)flag;

// returns completely-resolved path, eg: "/private/etc/postfix/aliases" for "/etc/aliases" (instead of simply "/etc/postfix/aliases" as does stringByResolvingSymlinksInPath)
- (NSString*)pc_stringByResolvingSymlinksInPathCompletely;

- (NSString*)pc_stringByTrimmingPathToUsersDirectory;

- (NSString*)pc_pathDisplayName;
- (NSString*)pc_pathDisplayNameWithoutExtension;

// Appends copySuffix and a numerical suffix if needed. copySuffix may be nil to affect only a numerical index
- (NSString*)pc_filenameUniqueToPath:(NSString*)folderPath copySuffix:(NSString*)copySuffix;
- (NSString*)pc_filenameUniqueToArray:(NSArray*)filenames copySuffix:(NSString*)copySuffix;	
- (NSString*)pc_stringUniqueToArray:(NSArray*)filenames copySuffix:(NSString*)copySuffix;

// Appends a numerical suffix if needed.
- (NSString*)pc_stringUniqueToSet:(NSSet*)strings; 

@end
