#import <AppKit/AppKit.h>


@interface NSWorkspace (PCAdditions)

+ (AuthorizationRef)pc_createAuthorizationForPrivilegedExec:(NSError**)outError;
+ (NSString*)pc_bootDiskDisplayName; // eg: "Macintosh HD"
+ (NSString*)pc_bootDiskPath; // eg: "/Volumes/Macintosh HD"
+ (void)pc_resetBootDiskValues;
+ (NSString*)pc_computerName;
- (SInt32)pc_systemVersion; // eg: 0x1050

- (NSArray*)pc_fileLabels;
- (NSArray*)pc_fileLabelColors; // the first color is white, corresponding to "None"

- (BOOL)pc_isVolumeVisibleAtPath:(NSString*)volumePath isRemovable:(BOOL*)removableFlag;

- (NSURL*)pc_URLRelativeToVolumeAtPath:(NSString*)fullPath;

- (NSEnumerator*)pc_processInformationEnumerator; // enumerates processes using GetNextProcess(), returning result of ProcessInformationCopyDictionary() for each

- (BOOL)pc_launchApplicationAtURL:(NSURL*)url inBackground:(BOOL)inBackground;
- (BOOL)pc_launchApplicationAtURL:(NSURL*)url inBackground:(BOOL)inBackground initialEvent:(AppleEvent*)initialEvent;
- (BOOL)pc_isApplicationRunningWithBundleIdentifier:(NSString*)identifier; // includes LSUIElement processes
- (BOOL)pc_isApplicationRunningWithBundleIdentifier:(NSString*)identifier processInfo:(NSDictionary**)info; // includes LSUIElement processes
- (BOOL)pc_quitApplicationsWithBundleIdentifier:(NSString*)identifier; // includes LSUIElement processes

- (BOOL)pc_openFile:(NSString*)fullPath; // blah blah Path Finder

- (NSString*)pc_userEmailAddress;

@end
