/*
 *  PCAlertSoundPlayer.h
 *
 *	Provides a wrapper for playing sound files
 *
 *	-------------------------------------------------------------------
 *
 *
 */


#import <AudioToolbox/AudioToolbox.h>
#import <Foundation/Foundation.h>


@interface PCSoundRegistry : NSObject

+ (PCSoundRegistry*)defaultRegistry;

- (NSArray*)availableSystemSounds;

@end


@interface PCAlertSoundPlayer : NSObject
{
	NSString* iSystemSoundPath;
	SystemSoundID iSystemSoundID;
}

@property(nonatomic, copy) NSString* soundPath;
@property(nonatomic, assign) SystemSoundID soundID;

- (void)play;

- (void)observeUserDefaultsSoundPathKey:(NSString*)defaultKey;

@end
