#import <Cocoa/Cocoa.h>

@class PCTimer;

@interface PCAnimatingOutlineView : NSOutlineView
{
	PCTimer			*iAnimationTimer;
	NSMutableSet	*iIndeterminateItems;
	NSInteger		iAnimatingRows[1000];
	NSTimeInterval	iAnimationInterval;
	NSString		*iAnimatingColumnIdentifier;
	SEL				iCellAnimationSelector;
}

@property (retain) NSString *animatingColumnIdentifier;

- (void)setAnimationInterval:(NSTimeInterval)interval;
- (void)setCellAnimationSelector:(SEL)aSelector;
- (void)startAnimationWithItem:(id)item;
- (void)stopAnimationWithItem:(id)item;

- (void)redrawAnimatingItems:(NSTimer*)timer;
- (void)resetAnimatingRows;

- (void)intializeInternals;

@end


@interface NSObject (DelegateAdditions)

- (void)outlineView:(NSOutlineView*)aOutlineView willAnimateTableColumn:(NSTableColumn*)col item:(id)anItem;

@end