#import <libkern/OSAtomic.h>
#import <assert.h>


// this should be treated as a void** but is typed as void* to simplify calling since it accepts any underlying pointer type
typedef void* PCPointerLocation;


static inline bool PCAtomicCompareAndSwapPtrBarrier(void* oldValue, void* newValue, PCPointerLocation theValue)
{
	assert(((uintptr_t)theValue & (sizeof(void*) - 1)) == 0); // must be aligned
	
	return OSAtomicCompareAndSwapPtrBarrier(oldValue, newValue, theValue);
}
