/*
 *  PCBaseOutlineView.h
 *
 *  Requires Mac OS X 10.4 or higher and NSEvent-CommonKeys, NSMenu-ContextualMenuValidation categories
 *
 *  Optional: requires drag badge images if providing a custom drag image
 *
 *	Provides a base outline view class for detecting key presses via the delegate.
 *  Also handles contextual menus properly.
 *
 *	-------------------------------------------------------------------
 *
 */

#import <Cocoa/Cocoa.h>


@interface PCBaseOutlineView : NSOutlineView 
{
	NSImage *iBaseDragImage;
	NSMutableArray *iExpandedPersistentItems;
	BOOL iCanFocusCells;
}

@property(copy) NSImage* baseDragImage;
@property(readwrite, assign) BOOL canFocusCells;

- (void)cacheExpandedRows;
- (void)restoreExpandedRows;

- (BOOL)cancelEditing;
- (BOOL)commitEditing;

@end


@interface NSObject (PCBaseOutlineViewDelegate)

- (BOOL)outlineView:(NSOutlineView*)outlineView keyDown:(NSEvent*)anEvent;
- (BOOL)outlineView:(NSOutlineView*)outlineView swipe:(NSEvent*)anEvent;
- (void)outlineView:(NSOutlineView*)outlineView didEndDragOperation:(NSDragOperation)operation;

@end
