/*
 *  PCBaseTableView.h
 *
 *  Requires Mac OS X 10.4 or higher and NSEvent-CommonKeys, NSMenu-ContextualMenuValidation categories
 *
 *  Optional: requires drag badge images if providing a custom drag image
 *
 *	Provides a base table view class for detecting key presses via the delegate.
 *  Also handles contextual menus properly.
 *
 *	-------------------------------------------------------------------
 *
 */
 
 #import <Cocoa/Cocoa.h>


@interface PCBaseTableView : NSTableView
{
	NSImage *baseDragImage;
	BOOL iCanFocusCells;
}

@property (readwrite, assign) BOOL canFocusCells;

- (void)setBaseDragImage:(NSImage*)anImage;

- (BOOL)commitEditing;
- (BOOL)cancelEditing;

@end


@interface NSObject (PCBaseTableViewDelegate)

- (BOOL)tableView:(NSTableView*)tableView keyDown:(NSEvent*)anEvent;
- (void)tableView:(NSTableView*)tableView didEndDragOperation:(NSDragOperation)operation;

@end
