// Provides a white window with a light blue stroke.

#import <PanicCore/NSBezierPath-Bubbles.h>
#import <PanicCore/PCSourceAnnotations.h>

#define kPCBubbleWindowBorderPadding 16


@interface PCBubbleWindow : NSWindow
{
	NSTimer*			timer;
	//CGFloat			cornerRadius;
	//CGFloat			triangleDistance;
	NSViewAnimation*	closeAnimation;
	BOOL				releaseOnClose;
	BOOL				canBecomeKey;
	BOOL				forwardScrollWheelEvents;
}

- (id)initWithRect:(NSRect)aRect;
- (id)initWithView:(NSView*)displayView bubbleEdge:(int)edge;

- (void)fadeClose;
- (void)fadeCloseAndRelease;
- (void)fadeCloseAfterDelay:(NSTimeInterval)seconds;
- (void)fadeCloseWithTimer:(NSTimer*)aTimer;
- (void)fadeOpen;
- (void)fadeOpenAtPoint:(NSPoint)aPoint;
- (void)fadeOpenAndCloseAfterInterval:(NSTimeInterval)seconds;
- (void)setBubbleEdge:(int)edge;
- (int)bubbleEdge;
- (void)setClosesOnClick:(BOOL)flag;
- (void)setView:(NSView*)aView;

- (void)setTriangleAlignment:(PCTriangleAlignment)anAlignment;
- (void)setCornerRadius:(CGFloat)inRadius;
- (void)setTriangleDistance:(CGFloat)inDistance;
- (void)setUsesDarkAppearance:(BOOL)flag;

- (void)updateLayout;

- (void)setCanBecomeKey:(BOOL)flag; // NO by default

// Pass in the last view you wish to have in the responder chain... after this 
// view resigns key, the parent window of the bubble window will be made key
- (void)setResignsKeyWindowAfterView:(NSView*)lastResponder;

// private - only for subclasses

- (id)internalInitWithRect:(NSRect)aRect bubbleEdge:(int)edge NS_RETURNS_RETAINED;

@end


@interface PCBubbleContentView : NSView
{
	NSImage*			backgroundImage;
	int					bubbleEdge; //NSRectEdge or -1
	CGFloat				borderPadding;
	CGFloat				cornerRadius;
	CGFloat				triangleDistance;
	PCTriangleAlignment	triangleAlignment;
	BOOL				closesOnClick;
	BOOL				iUsesDarkAppearance;
}

- (id)initWithFrame:(NSRect)aRect bubbleEdge:(int)edge;

@property (nonatomic, assign) BOOL usesDarkAppearance;
@property (nonatomic, assign) BOOL closesOnClick;
@property (nonatomic, assign) CGFloat cornerRadius;
@property (nonatomic, retain) NSImage *backgroundImage; 

- (int)bubbleEdge;
- (void)setBubbleEdge:(int)edge;
- (void)setTriangleAlignment:(PCTriangleAlignment)anAlignment;
- (void)setTriangleDistance:(CGFloat)inDistance;

// private - only for subclasses

- (NSBezierPath*)bubblePathWithLineWidth:(CGFloat)lineWidth inset:(CGFloat)inset;
- (void)updateBackgroundImageForSize:(NSSize)aSize;

@end


@interface PCBubbleResignKeyWindowView : NSTextField
{
}

@end

