#if TARGET_OS_IPHONE
	#import <Foundation/Foundation.h>
	#import <UIKit/UIKit.h>
#else
	#import <Cocoa/Cocoa.h>
#endif
#import <QuartzCore/QuartzCore.h>

@class PCView;
@class PCEvent;

@interface PCButtonLayer : CALayer
{
#if TARGET_OS_IPHONE
	BOOL			trackingTouches;
#endif
	BOOL			iHighlighted;
	__weak NSObject	*iEventDelegate;
}

@property(nonatomic, assign) BOOL highlighted;
@property(nonatomic, assign) __weak NSObject *eventDelegate;

#if TARGET_OS_IPHONE
- (void)touchesBegan:(NSSet *)touches withEvent:(PCEvent *)event inView:(PCView *)eventView;
- (void)touchesCancelled:(NSSet *)touches withEvent:(PCEvent *)event inView:(PCView *)eventView;
- (void)touchesMoved:(NSSet *)touches withEvent:(PCEvent *)event inView:(PCView *)eventView;
- (void)touchesEnded:(NSSet *)touches withEvent:(PCEvent *)event inView:(PCView *)eventView;
#else
- (void)trackMouseDownEvent:(PCEvent *)event inView:(PCView *)eventView;
#endif

@end


@interface NSObject (PCButtonLayerDelegate)

- (BOOL)mouseDragged:(PCEvent*)event inButtonLayer:(PCButtonLayer*)layer;
- (void)mouseUp:(PCEvent*)event inButtonLayer:(PCButtonLayer*)layer;
- (void)buttonLayer:(PCButtonLayer *)buttonLayer highlighted:(BOOL)highlighted;

@end
