#import <Cocoa/Cocoa.h>

typedef enum
{
	kCapsuleStyleSourceList,
	kCapsuleStyleRecessed
} PCCapsuleStyle;


@interface PCCapsuleTextField : NSTextField
{}

- (PCCapsuleStyle)capsuleStyle;
- (void)setCapsuleStyle:(PCCapsuleStyle)style;

@end


@interface PCCapsuleTextFieldCell : NSTextFieldCell
{
	PCCapsuleStyle iCapsuleStyle;
	NSColor* iColor;
	NSImage* iCachedCapsuleImage;
}

@property (nonatomic, assign) PCCapsuleStyle capsuleStyle;
@property (nonatomic, retain) NSColor *color;

- (void)drawCapsuleWithFrame:(NSRect)cellFrame inView:(NSView*)controlView;

@end
