//
//  PCControlsConfiguration.h
//  CustomControlsDemo
//
//  Created by Wade Cosgrove on 2/15/06.
//  Copyright 2006 Panic, Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>

typedef enum
{
	kNoGradient,
	kAppearanceVariant,
	kSunkenToolbar,
	kLightAppearanceVariant,
	kLightTabAppearance,
	kAppearanceSourceList,
	kControlTintSourceList,
	kControlTintList,
	kMailSourceList,
	kiAppButton,
	kCSSHeader,
	kCSSBackground,
	kRoundedGradient,
	kSmallRoundedGradient,
	kTexturedRoundedGradient
} PCControlGradientStyle;

typedef enum
{
	kNoBezel = 0,
	kSmallBezel = 1 << 0,
	kNoLeftBezel = 1 << 1,
	kNoRightBezel = 1 << 2,
	kNoTopBezel = 1 << 3,
	kNoBottomBezel = 1 << 4
} PCControlBezelStyle;

@class PCControlGradient;

@interface PCControlsConfiguration : NSObject
{
}

+ (NSColor*)bezelColorForStyle:(PCControlBezelStyle)bezelStyle gradientStyle:(PCControlGradientStyle)gradientStyle;
+ (NSColor*)selectedBezelColorForStyle:(PCControlBezelStyle)bezelStyle gradientStyle:(PCControlGradientStyle)gradientStyle;
+ (PCControlGradient*)bezelGradientForStyle:(PCControlGradientStyle)style;
+ (double)bezelThicknessForStyle:(PCControlBezelStyle)bezelStyle;

+ (void)cacheCellRightBezel:(NSImage**)rightBezel leftBezel:(NSImage**)leftBezel forGradientStyle:(PCControlGradientStyle)style withHeight:(double)height;

+ (PCControlGradient*)fillGradientForStyle:(PCControlGradientStyle)style;
+ (PCControlGradient*)highlightedFillGradientForStyle:(PCControlGradientStyle)style;
+ (PCControlGradient*)highlightedSelectedFillGradientForStyle:(PCControlGradientStyle)style;
+ (PCControlGradient*)selectedFillGradientForStyle:(PCControlGradientStyle)style;
+ (PCControlGradient*)selectedInactiveFillGradientForStyle:(PCControlGradientStyle)style;
+ (PCControlGradient*)selectedDisabledFillGradientForStyle:(PCControlGradientStyle)style;

+ (BOOL)shouldHighlightTextWhiteForStyle:(PCControlGradientStyle)style;

+ (NSImage*)glossBackgroundImageWithSize:(NSSize)aSize bezel:(PCControlBezelStyle)bezelStyle;
+ (NSImage*)HUDBackgroundImageWithFrame:(NSRect)aRect radius:(float)radius enabled:(BOOL)isEnabled selected:(BOOL)isSelected bezierPath:(NSBezierPath**)outPath;
+ (NSImage*)HUDBackgroundImageWithFrame:(NSRect)aRect radius:(float)radius enabled:(BOOL)isEnabled selected:(BOOL)isSelected bezierPath:(NSBezierPath**)outPath color:(NSColor*)aColor;
+ (NSGradient*)HUDBezelGradientEnabled:(BOOL)enabled selected:(BOOL)selected;

@end


@interface PCControlGradient : NSGradient
{
	NSColor* iLineColor;
}

@property (readwrite, retain) NSColor* lineColor;

- (void)drawRowSelectionInRect:(NSRect)rect;

@end
