#import <Cocoa/Cocoa.h>

@interface PCDarkGlossSegmentedControl : NSSegmentedControl
{
}

+ (NSImage*)backgroundImageWithSize:(NSSize)size bordered:(BOOL)drawBorder;

@property (nonatomic) BOOL drawsSecondarySelectionColor;

@end


@interface PCDarkGlossSegmentedCell : NSSegmentedCell
{
@private
	NSImage		*backgroundImage;
	NSImage		*pressedBackgroundImage;
	NSImage		*selectedBackgroundImage;
	NSImage		*selectedPressedBackgroundImage;

	NSSize		cachedImageSize;
	BOOL		shouldDrawCellBackground;
	
	BOOL		iDrawsSecondarySelectionColor;
}

@property (nonatomic) BOOL drawsSecondarySelectionColor;

- (NSImage*)backgroundImageWithSize:(NSSize)aSize bordered:(BOOL)flag;
- (NSImage*)backgroundImageWithSize:(NSSize)size dividerColor:(NSColor*)dividerColor bezelColor:(NSColor*)bezelColor upperGradient:(NSGradient*)upperGradient lowerGradient:(NSGradient*)lowerGradient;

- (void)drawFocusRingWithFrame:(NSRect)cellFrame;
- (void)updateBackgroundForSize:(NSSize)aSize;

@end


@interface PCDarkSegmentedLabelCell : NSCell
{
	
}

@end


@interface NSSegmentedCell (PrivateDeclaration)

+ (id)_labelCell;
- (void)_drawBackgroundWithFrame:(NSRect)cellFrame inView:(NSView *)controlView;
- (NSRect)_rectForSegment:(int)segment inFrame:(NSRect)rect;
- (NSRect)_boundsForCellFrame:(NSRect)rect;

@end


@interface NSCell (PrivateDeclaration)

- (NSDictionary*)_textAttributes;

@end