#import <Cocoa/Cocoa.h>

/*
 *  PCDarkGradientRolloverButton.h
 *
 *  Requires Mac OS X 10.5 or higher
 *	
 *
 *	A HUD style rounded gradient button.
 *
 *	-------------------------------------------------------------------
 *
 *
 */


@interface PCDarkGradientRolloverButton : NSButton
{
	NSTrackingArea *iRolloverArea;
}

@end



@interface PCDarkGradientRolloverButtonCell : NSButtonCell
{
	NSGradient		*iHighlightedGradient;
	NSGradient		*iOnStateGradient;
	NSGradient		*iRolloverGradient;

	BOOL			iRolloverHighlighted;
}

@property (nonatomic, assign, getter=isRolloverHighlighted) BOOL rolloverHighlighted;

@end
