#import <Cocoa/Cocoa.h>

/*
 *  PCEtchedTextField.h
 *
 *  Requires Mac OS X 10.0 or higher
 *
 *	Provides a text field with an etched appearance for use in a window's bottom bar
 *
 *	-------------------------------------------------------------------
 *
 *	setShowsSizeBubble
 *	Sets whether or not to show the size bubble when mouse is in the slider for a half second
 *
 *	setSizeBubbleString
 * 	Sets the string to be displayed in the size bubble
 *
 */


@interface PCEtchedTextField : NSTextField
{
	BOOL iShowsInactiveState;
	BOOL iNotificationsRegistered;
}

@property (nonatomic, assign) BOOL showsInactiveState;

- (void)setEtchingColor:(NSColor*)aColor;

@end


@interface PCEtchedTextFieldCell : NSTextFieldCell
{
	NSColor *etchingColor;
}

- (void)setEtchingColor:(NSColor*)aColor;

@end
