#import <Cocoa/Cocoa.h>

/*
 *  PCExpiredView.h
 *
 *	Required localized strings: EnterSerialNumberButtonTitle, PurchaseButtonTitle, TrialTimeoutNagString
 *
 *	Optional images (suggested): expired-bang-violator.pdf
 *
 *	Provides a generic expired view in Panic style.
 *
 *	-------------------------------------------------------------------
 *
 *
 */

@interface PCExpiredView : NSView
{
	IBOutlet NSView* oCenterView;
	IBOutlet NSImageView* oIconView;
	IBOutlet NSTextField* oTitleView;
	IBOutlet NSTextField* oTextView;
	
	IBOutlet NSButton* oPurchaseButton; 
	IBOutlet NSButton* oEnterSerialNumberButton;
	NSArray* iButtons;
	
	CGFloat iMinWidthWithIcon;
	
	NSInteger iTrialPeriod;
	NSTimeInterval iTrialTimeout;
}

- (id)initWithFrame:(NSRect)frame trailPeriod:(NSInteger)periodInDays timeoutInterval:(NSTimeInterval)timeout;

@property(copy) NSArray* buttons; // nil to use buy and unlock buttons as defined in nib
@property(nonatomic) CGFloat minimumWidth;
@property NSInteger trialPeriodInDays;
@property NSTimeInterval trialTimeoutInterval;

- (void)updateDemoLayout;

@end
