#import <PanicCore/PCControlsConfiguration.h>

@interface PCGlossPopUpButtonCell : NSPopUpButtonCell
{
@private
	NSImage *backgroundImage;
	NSImage *backgroundImagePressed;
	PCControlBezelStyle	bezel;
	NSImage	*arrow;
	NSImage *arrowDisabled;
	
	NSMenu		*defaultMenu;
	NSMenuItem	*buttonMenuItem;
}

- (void)setBezel:(PCControlBezelStyle)inBezel;
- (NSMenu*)contextSensitiveMenu;
- (void)setContextSensitiveMenu:(NSMenu*)aMenu;

// private

- (void)configure;
- (void)updateBackgroundForSize:(NSSize)size;
- (void)setTemplateImage:(NSImage*)anImage;

@end


@interface PCGlossPopUpButton : NSPopUpButton
{
	id I_delegate;
}

- (NSMenu*)contextSensitiveMenu;
- (void)setContextSensitiveMenu:(NSMenu*)aMenu;

- (id)delegate;
- (void)setDelegate:(id)aDelegate;
- (void)setTemplateImage:(NSImage*)anImage;

// private

- (void)configure;

@end

@interface NSObject(PCGlossPopUpButtonDelegateAdditions) 
- (void)popUpWillShowMenu:(NSPopUpButton *)aButton;
@end
