#import <PanicCore/PCControlsConfiguration.h>

@interface PCGradientButtonCell : NSButtonCell
{
	NSGradient	*iFillGradient;
	NSGradient	*iHighlightedFillGradient;
	NSColor		*iBezelColor;
	NSGradient 	*iBezelGradient; // if non-nil, uses this, otherwise bezel color if non-nil
	NSColor		*iShadowColor; // shadow under the control, default is nil
	CGFloat		iCornerRadius;
	PCControlGradientStyle	gradientStyle;
	
	NSColor *iTextColor;
	NSShadow *iTextShadow;
}

@property (nonatomic, assign, readwrite) CGFloat cornerRadius;
@property (nonatomic, retain, readwrite) NSColor *bezelColor;
@property (nonatomic, retain, readwrite) NSGradient *bezelGradient;
@property (nonatomic, retain, readwrite) NSGradient *fillGradient;
@property (nonatomic, retain, readwrite) NSGradient *highlightedFillGradient;
@property (nonatomic, retain, readwrite) NSColor *shadowColor;
@property (nonatomic, retain, readwrite) NSShadow *textShadow;
@property (nonatomic, retain, readwrite) NSColor *textColor;

- (PCControlGradientStyle)gradientStyle;
- (void)setGradientStyle:(PCControlGradientStyle)style;

@end
