#import <Cocoa/Cocoa.h>


@interface PCHUDTextField : NSTextField 
{
	NSTrackingArea *iRolloverArea;
}

- (BOOL)isEditableOnlyWhenMouseInside;

- (void)setEditableOnlyWhenMouseInside:(BOOL)flag;
- (void)setShadow:(NSShadow*)textShadow;


@end


@interface PCHUDTextFieldCell : NSTextFieldCell 
{
	BOOL	iEditableOnlyWhenMouseInside;
	NSShadow *iShadow;
}

@property (retain) NSShadow *shadow;
@property (assign, getter=isEditableOnlyWhenMouseInside) BOOL editableOnlyWhenMouseInside;

@end


@interface PCSecureFieldEditor : NSTextView
{}
@end


@interface PCHUDSecureTextField : PCHUDTextField /*NSSecureTextField*/ 
{}

- (NSTextView*)fieldEditor;

@end


@interface PCHUDSecureTextFieldCell : PCHUDTextFieldCell /*NSSecureTextFieldCell*/
{
	PCSecureFieldEditor *iFieldEditor;
	BOOL				iSecureInputEnabled;
}

- (NSTextView*)fieldEditor;
- (void)setSecureInputEnabled:(BOOL)flag;

@end



@interface NSCell (PrivateToPublic)

- (NSDictionary*)_textAttributes;

@end
