#import <PanicCore/PCControlsConfiguration.h>


@interface PCMatrix : NSMatrix
{
	NSGradient *fillGradient;
	NSGradient *selectedFillGradient;
	NSGradient *bezelGradient;
		
	NSColor					*bezelColor;
	
	PCControlGradientStyle	gradientStyle;
	PCControlBezelStyle		bezelStyle;
	
	// inner bezel caching
	
	NSImage *cachedLeftBezel;
	NSImage *cachedRightBezel;
	
	NSMutableArray* accessoryTrackingRects;
}

- (PCControlBezelStyle)bezelStyle;
- (void)setBezelStyle:(PCControlBezelStyle)style;

- (PCControlGradientStyle)gradientStyle;
- (void)setGradientStyle:(PCControlGradientStyle)style;

- (void)clearTrackingRects;
- (void)resetTrackingRects;

- (BOOL)shouldHighlightTextWhite;

- (BOOL)trackAccessoryCellWithEvent:(NSEvent*)theEvent;

@end


@interface PCMatrixCell : NSButtonCell
{
	NSAttributedString*	attributedTitle;
	NSAttributedString*	highlightedAttributedTitle;
	
	NSButtonCell*		accessoryButtonCell;
	NSImage*			accessoryButtonImage;
	NSImage*			accessoryButtonHighlightedImage;
	NSImage*			accessoryButtonRolloverImage;
	BOOL				showsAccessoryButton;
	BOOL				drawsRolloverImage;
	
	NSGradient*	fillGradient;
	NSGradient*	selectedFillGradient;
}

- (NSButtonCell*)accessoryButtonCell;
- (NSRect)accessoryRectForBounds:(NSRect)cellFrame;
- (void)createAccessoryButtonIfNeeded;
- (void)setAccessoryImage:(NSImage*)image;
- (void)setAccessoryRolloverImage:(NSImage*)image;
- (void)setAccessoryHighlightedImage:(NSImage*)image;
- (void)setAccessoryAction:(SEL)selector;
- (void)setAccessoryTarget:(id)target;
- (void)setDrawsRolloverImage:(BOOL)flag;
- (void)setShowsAccessoryButton:(BOOL)flag;
- (BOOL)showsAccessoryButton;

@end

