// Provides a button that looks like Safari 4's tab close button

#import <Cocoa/Cocoa.h>


@interface PCRecessedRolloverButton : NSButton
{
	NSTrackingArea *iRolloverTrackingArea;
}

- (NSImage*)inactiveImage;
- (void)setInactiveImage:(NSImage*)anImage;

- (void)setTemplateHighlightImage:(NSImage*)anImage;

@end


@interface PCRecessedRolloverButtonCell : NSButtonCell
{
	BOOL	iRolloverHighlighted;
	NSImage	*iInactiveImage;
	NSImage *iTemplateHighlightImage;
	
	// The background images default to the static background images
	// unless the button is a different size.
	
	NSImage *iActiveBackground;
	NSImage *iActiveRolloverBackground;
	NSImage *iInactiveBackground;
	NSImage *iInactiveRolloverBackground;
	NSImage *iHighlightedBackground;
	NSImage *iDisabledBackground;
}

@property (nonatomic, assign, getter=isRolloverHighlighted) BOOL rolloverHighlighted;
@property (nonatomic, retain) NSImage *inactiveImage;

- (void)setTemplateHighlightImage:(NSImage*)anImage;

@end
