//
// Reads and writes the users SSH config file
//

#import <Cocoa/Cocoa.h>

@class PCSSHHostLine;

@interface PCSSHConfigParser : NSObject 
{
	NSString *indent1;
	NSString *indent2;
	NSString *space1;	
}

+ (NSArray*)hostEntriesForUser;

+ (NSArray*)hostEntriesAtPath:(NSString*)aPath;

@end


@interface PCSSHHostGroup : NSObject
{
	NSString		*iHost;
	NSMutableArray	*iEntries;
}

@property (copy) NSString *host;
@property (copy) NSMutableArray *entries;

+ (PCSSHHostGroup*)groupWithHost:(NSString*)aHost;
- (PCSSHHostGroup*)initWithHost:(NSString*)aHost;

- (void)addLine:(PCSSHHostLine*)line;

+ (NSArray*)supportedKeys;

@end


@interface PCSSHHostLine : NSObject
{
	NSString *iLine;
	NSString *iKey;
	NSString *iValue;
	NSUInteger iLineNumber;
}

@property (copy) NSString *line;
@property (copy) NSString *key;
@property (copy) NSString *value;
@property NSUInteger lineNumber;


+ (PCSSHHostLine*)entryWithLine:(NSString*)aLine key:(NSString*)aKey value:(NSString*)aValue lineNumber:(NSUInteger)aLineNumber;
+ (PCSSHHostLine*)entryWithLine:(NSString*)aLine lineNumber:(NSUInteger)aLineNumber;

@end