#import <Cocoa/Cocoa.h>

#import "PCControlsConfiguration.h"

@class PCControlGradient;

@interface PCSegmentedControl : NSSegmentedControl
{
	PCControlGradient		*fillGradient;
	PCControlGradient		*highlightedFillGradient;
	PCControlGradient		*selectedFillGradient;
	PCControlGradient		*highlightedSelectedFillGradient;
		
	NSColor					*bezelColor;
	NSColor					*selectedBezelColor;
	
	BOOL					autoCalculateCellWidth;
	
	PCControlGradientStyle	gradientStyle;
	CGFloat					iCornerRadius;

	NSBezierPath			*iControlPath;
	NSRect					*cellFrames;
	
	// inner bezel caching
	
	NSImage					*cachedLeftBezel;
	NSImage					*cachedRightBezel;

	float					highlightAlpha;
}

@property (assign) CGFloat cornerRadius;

- (PCControlBezelStyle)segmentBezelStyle;
- (void)setSegmentBezelStyle:(PCControlBezelStyle)style;

- (PCControlGradientStyle)gradientStyle;
- (void)setGradientStyle:(PCControlGradientStyle)style;

- (void)setAutoCalculatesCellWidth:(BOOL)flag;
- (void)setImagePosition:(NSCellImagePosition)aPosition;

- (BOOL)shouldHighlightTextWhite;

- (void)setHighlightAlpha:(float)inAlpha;
- (float)highlightAlpha;

@end


@interface PCSegmentedCell : NSSegmentedCell
{
	NSDictionary *normalFontAttrs;
	NSDictionary *disabledFontAttrs;
	NSDictionary *highlightedFontAtrrs;
	
	NSCellImagePosition		imagePosition;
	PCControlBezelStyle		bezelStyle;

	// layout vars

	int		bezelPadding;
	int		iconPadding;
	BOOL	shouldDrawMenuIndicator;
	
	NSSize	imageDisplaySize;
}

- (PCControlBezelStyle)segmentBezelStyle;
- (NSCellImagePosition)imagePosition;

- (void)setSegmentBezelStyle:(PCControlBezelStyle)style;
- (void)setDrawsMenuIndicator:(BOOL)flag;
- (void)setImagePosition:(NSCellImagePosition)aPosition;
- (void)setGradientStyle:(PCControlGradientStyle)style;

- (void)setImageDisplaySize:(NSSize)aSize;
- (NSSize)imageDisplaySizeForSegment:(int)segment;

@end