/*
 *  PCShrinkingFontField.h
 *
 *  Requires Mac OS X 10.4 or higher and PCShadowedTextField
 *
 *	Provides a text field that scales its font size to fit the width of the field,
 *	thus preventing regular text truncation unless the minimum size has been reached.
 *
 *	------------------------------------------------------------------------------
 *
 *
 */
 
 #import <PanicCore/PCShadowedTextField.h>


@interface PCShrinkingFontField : PCShadowedTextField
{
	float minimumFontSize;
	float defaultFontSize;
}

- (void)setDefaultFontSize:(float)size;


// private

- (void)updateTextSize;

@end