/*
 *  PCSplitView.h
 *
 *  Requires Mac OS X 10.5 or higher and NSImage-Additions, 
 *	and PCControlsConfiguration. Also requires the image split-view-button.
 *
 *	-------------------------------------------------------------------
 *
 */

#import <Cocoa/Cocoa.h>


typedef enum
{
	kStandardAquaDivider = 1,
	kStreamlinedDivider,
	kAquaGradientDivider,
	kCustomDivider				// draws the divider color
} PCSplitViewDividerStyle;


@interface PCSplitView : NSSplitView 
{
	NSGradient*		dividerGradient;
	
	PCSplitViewDividerStyle dividerStyle;
	CGFloat					iDividerThickness;
	
	NSImage		*iCustomDividerImage;
	NSRectEdge	iCustomDividerEdge;
	CGFloat		iCustomDividerLocation; // the x or y origin of the custom divider image
	NSColor		*iDividerColor;
	
	NSTimeInterval animationInterval;
	NSDate*		animationStartDate;
	CGFloat		animationStartSize;
	CGFloat		animationEndSize;
	NSView*		secondaryView;
	NSView*		targetView;
	NSTimer*	animationTimer;
	
	CGFloat		minimumSize;
}

@property (assign) NSRectEdge customDividerEdge;
@property (assign) CGFloat	customDividerLocation; // will use the location instead of edge, if > -1
@property (retain) NSImage	*customDividerImage;
@property (retain) NSColor	*dividerColor;
@property (assign) CGFloat	dividerThickness;


- (BOOL)addSubview:(NSView*)subview atIndex:(NSUInteger)index animate:(BOOL)flag;
- (BOOL)animateSubviewAtIndex:(NSUInteger)index toSize:(CGFloat)targetSize;

- (void)addSubviewSizedProportionally:(NSView*)subview atIndex:(NSUInteger)index;

- (void)setHeight:(CGFloat)height ofSubviewAtIndex:(NSUInteger)index;
- (void)setWidth:(CGFloat)height ofSubviewAtIndex:(NSUInteger)index;
- (void)removeSubviewAtIndex:(NSUInteger)index;

- (BOOL)isAnimating;
- (void)stopAnimation;

- (void)setDividerType:(PCSplitViewDividerStyle)style;
- (void)setDrawsGlossBottom:(BOOL)flag; // deprecated, use setCustomDividerImage:, setCustomDividerEdge:
 
- (CGFloat)minimumSplitSize;
- (void)setMinimumSplitSize:(CGFloat)newMinimum;
 
- (void)animationDidEnd:(NSView*)aView;

@end


@interface PCSplitView (PCSplitViewDelegate)
- (void)splitViewDidEndUserResize:(PCSplitView*)aSplitView;
- (void)splitView:(PCSplitView*)aSplitView didCompleteAnimationOfSubviewAt:(NSUInteger)index;
@end


@interface PCSplitAnimationView : NSView
{	
	NSView *pendingView;
}

- (id)initWithView:(NSView*)aView;
- (NSView*)pendingView;
- (void)setPinToTop:(BOOL)flag;

@end
