#import <Cocoa/Cocoa.h>

/*
 *  PCStripedView.h
 *
 *  Requires Mac OS X 10.5
 *
 *
 *	Draws diagonal stripes in the view. Useful for placards and view headers.
 *
 *	-------------------------------------------------------------------
 *
 *
 */

@interface PCStripedView : NSView
{
	NSGradient *iStripeGradient1;
	NSGradient *iStripeGradient2;
	
	NSBezierPath *iStripesPath;
}

- (void)setStripe1Color:(NSColor*)startColor endColor:(NSColor*)endColor;
- (void)setStripe2Color:(NSColor*)startColor endColor:(NSColor*)endColor;

- (void)updateStripesPath;

@end
