#import <PanicCore/PCSlidingViewsBar.h>

#define PCTabBarDidChangeNotification		@"TabBarDidChangeNotification"

@protocol TabBarButtonProtocol
- (NSButton*)closeButton;
- (BOOL)isEdited;
- (void)setEdited:(BOOL)flag;
- (void)setSliding:(BOOL)flag;
- (BOOL)shouldHideCloseButton;
@end

@class PCColorView;
@class PCTabToolTip;


@interface PCTabBar : PCSlidingViewsBar
{
@private
	Class	buttonClass;
	BOOL	canCloseOnlyTab;
	BOOL	autoHide;
	__weak NSView	*contextualMenuButtonTarget;
	
	NSGradient *iBackgroundGradient;
	NSInteger	iSelectedTabIndex;
	BOOL		iShowsBaselineSeparator;
	
	// new
	
#if 1 // TABBAR_BUBBLE_TOOLTIP

	// bubble tooltip
	
	PCTabToolTip	*bubbleToolTip;
	NSInteger		bubbleToolTipIndex;
	NSTimer			*bubbleToolTipTimer;

#endif
	
	BOOL			showBubbleToolTips;
}

@property(retain) NSGradient* backgroundGradient;
@property NSInteger selectedTabIndex;
@property(nonatomic, assign) BOOL autoHides;

- (void)setButtonClass:(Class)aClass;

- (void)addTabWithTitle:(NSString*)title;
- (void)addTabWithTitle:(NSString*)title atIndex:(NSInteger)tabIndex;
- (void)closeAllTabsExcludingTabAtIndex:(NSInteger)tabIndex;
- (void)moveTabFromIndex:(NSInteger)originalIndex toIndex:(NSInteger)targetIndex;
- (BOOL)closeTabAtIndex:(NSInteger)index; // will ask if closing is OK
- (void)removeTabAtIndex:(NSInteger)index; // removes tab immediately, without asking
- (void)selectTabAtIndex:(NSInteger)index;

- (NSInteger)numberOfTabs;
- (NSInteger)selectedTabIndex;

- (BOOL)isEditedForTabAtIndex:(NSInteger)index;

- (BOOL)canCloseOnlyTab;
- (void)setCanCloseOnlyTab:(BOOL)flag;

- (BOOL)isVisible;
- (void)setVisible:(BOOL)flag;

- (void)setShowsBaselineSeparator:(BOOL)flag;

- (void)reloadData;

- (NSRect)windowAutosaveFrame;
- (NSRect)usedRect; // frame plus the divider frame

#if 1 // TABBAR_BUBBLE_TOOLTIP

- (void)setShowsBubbleToolTip:(BOOL)flag;

// private

- (void)closeBubbleToolTip;
- (void)displayBubbleToolTipForTabAtIndex:(NSInteger)index;
- (void)setBubbleToolTipIndex:(NSInteger)index;

#endif

- (void)tabCountChanged;


// layout

- (CGFloat)maxButtonWidth;
- (CGFloat)minButtonWidth;
- (CGFloat)minSelectedButtonWidth;

//- (NSRect)frameWithProposedFrame:(NSRect)inFrame forButton:(NSView*)button;
- (CGFloat)slidingWidthForView:(NSView*)aView;


// subclass hooks

- (void)configureTabButton:(NSButton*)aButton;
- (void)drawBackgroundInRect:(NSRect)aRect;
- (void)drawBaselineSeparatorInRect:(NSRect)aRect;

@end


@protocol PCTabBarDelegate

@required
- (NSInteger)numberOfRowsInTabBar:(PCTabBar *)tabBar;
- (NSString*)tabBar:(PCTabBar *)bar titleForTabAtIndex:(NSInteger)index;

@optional
- (void)createNewTabForTabBar:(PCTabBar*)bar;
- (BOOL)tabBar:(PCTabBar*)bar acceptDrop:(id <NSDraggingInfo>)draggingInfo tabAtIndex:(NSInteger)index;
- (void)tabBar:(PCTabBar*)bar duplicateTabAtIndex:(NSInteger)index;
- (void)tabBar:(PCTabBar*)bar closeOthersExceptTabAtIndex:(NSInteger)index;
- (void)tabBar:(PCTabBar*)bar didCloseTabAtIndex:(NSInteger)index;
- (void)tabBar:(PCTabBar*)bar didSwitchToTabAtIndex:(NSInteger)index;
- (BOOL)tabBar:(PCTabBar*)bar shouldCloseTabAtIndex:(NSInteger)index;
- (void)tabBar:(PCTabBar*)bar willAddTabAtIndex:(NSInteger)index;
- (void)tabBar:(PCTabBar*)bar willCloseTabAtIndex:(NSInteger)index;
- (void)tabBar:(PCTabBar*)bar willSwitchToTabAtIndex:(NSInteger)index;
- (void)tabBar:(PCTabBar*)bar willLayoutTabButton:(NSButton*)aButton atIndex:(NSInteger)index;

- (NSMenu*)tabBar:(PCTabBar*)bar popupMenuForTabAtIndex:(NSInteger)tabIndex;
- (void)tabBar:(PCTabBar*)bar willDisplayTabToolTip:(PCTabToolTip*)toolTip forTabAtIndex:(NSInteger)tabIndex;


@end

@interface PCTabBar (TabButtonSupport)

- (BOOL)acceptDrop:(id <NSDraggingInfo>)draggingInfo onTabButton:(id)sender;
- (void)selectTabButton:(id)sender;
- (void)closeTabButton:(id)sender;
- (NSMenu*)menuForTabButton:(id)sender;
- (void)mouseEnteredOrExited:(BOOL)didEnter tabButton:(id)sender;

@end

@interface PCTabBar (ContextualMenuSupport)

- (IBAction)duplicateTabContextualAction:(id)sender;
- (IBAction)closeTabContextualAction:(id)sender;
- (IBAction)closeOtherTabsContextualAction:(id)sender;
- (IBAction)newTabContextualAction:(id)sender;
- (IBAction)openTabInNewWindowContextualAction:(id)sender;

@end
