#import <Cocoa/Cocoa.h>

@interface PCTimer : NSObject 
{
@private
	__strong CFRunLoopTimerRef iTimer;
	NSInvocation* iTargetInvocation;
	id iUserInfo;
}

@property(readonly, retain) id userInfo;

// Note: This timer does not retain its target

+ (void)addTimerToRunLoop:(PCTimer*)timer;
+ (void)addTimerToRunLoop:(PCTimer*)timer forMode:(CFStringRef)mode; // Uses CFRunLoopModes

+ (PCTimer*)scheduledTimerWithTimeInterval:(NSTimeInterval)seconds invocation:(NSInvocation *)invocation repeats:(BOOL)repeats;
+ (PCTimer*)scheduledTimerWithTimeInterval:(NSTimeInterval)seconds target:(id)target selector:(SEL)selector userInfo:(id)userInfo repeats:(BOOL)repeats;
+ (PCTimer*)timerWithTimeInterval:(NSTimeInterval)seconds invocation:(NSInvocation *)invocation repeats:(BOOL)repeats;
+ (PCTimer*)timerWithTimeInterval:(NSTimeInterval)seconds target:(id)target selector:(SEL)selector userInfo:(id)userInfo repeats:(BOOL)repeats;

- (id)initWithFireDate:(NSDate *)date interval:(NSTimeInterval)seconds target:(id)target selector:(SEL)selector userInfo:(id)userInfo repeats:(BOOL)repeats;

- (BOOL)isValid;
- (void)invalidate;

- (void)fire;
- (NSDate*)fireDate;
- (void)setFireDate:(NSDate*)date;  

- (NSTimeInterval)timeInterval;

@end
