#import <PanicCore/PCShadowedTextField.h>

/*
 *  PCURLTextField.h
 *
 *  Requires Mac OS X 10.4 or higher and (by default) inherits from PCShadowedTextField
 *
 *	Provides a text field that users can click to open a URL. Has rollover effects
 *	and can specify the link text attributes.
 *
 *	-------------------------------------------------------------------
 *
 *
 */

@interface PCURLTextField : PCShadowedTextField
{
	NSColor* normalTextColor;
	NSColor* highlightedTextColor;
	int trackingRectTag;
	NSURL* url;
	BOOL isRolloverActive;
}

- (NSColor*)normalTextColor;
- (void)setNormalTextColor:(NSColor*)aColor;

- (NSColor*)highlightedTextColor;
- (void)setHighlightedTextColor:(NSColor*)aColor;

- (NSURL*)url;
- (void)setURL:(NSURL*)aURL;

@end

