#import <Cocoa/Cocoa.h>
#import <QuartzCore/QuartzCore.h>

/*
 *  PCViewAnimation.h
 *
 *  Requires Mac OS X 10.4 or higher
 *
 *	Provides a nice interface for various view animations.
 *	Fixes bugs in NSViewAnimation under 10.4.x when sliding views around.
 *
 *	-------------------------------------------------------------------
 *
 *
 */

@interface PCViewAnimation : NSObject
{
	NSAnimation		*viewAnimation;
	NSTimeInterval	duration;
	
	id				delegate;
	NSObject		*userData;
	
	int 			animationType;
	
	NSView*			fadeViewStart;
	NSView*			fadeViewEnd;
	NSView*			fadeViewPlaceholder;
}

- (void)animateViews:(NSArray*)views toRects:(NSArray*)rects useViewAnimation:(BOOL)flag;
- (void)animateViews:(NSArray*)views toRects:(NSArray*)rects; // same as above, with useViewAnimation set to NO

// This method will fade one view to the other, taking "startingView" out of the 
// view hierarchy and inserting "endView."  It will only fade the region in 
// "aClipRect" so you don't get crazy drawing bugs during the fade.

- (void)fadeView:(NSView*)startingView toView:(NSView*)endView clipRect:(NSRect)aClipRect;

// The typical NSViewAnimation crossfade

- (void)fadeView:(NSView*)startingView toView:(NSView*)endView;
- (void)fadeView:(NSView*)startingView toView:(NSView*)endView resizeWindow:(BOOL)flag;
- (void)fadeView:(NSView*)startingView toView:(NSView*)endView resizeWindowHorizontally:(BOOL)horizontalFlag vertically:(BOOL)verticalFlag;

- (BOOL)isAnimating;
- (void)stopAnimation;
- (void)setDuration:(NSTimeInterval)duration;

- (id)delegate;
- (void)setDelegate:(id)sender;

- (NSObject*)userData;
- (void)setUserData:(NSObject*)data;

@end


@interface NSObject (PCViewAnimationDelegate)
- (void)viewAnimationCompleted:(PCViewAnimation*)animation wasCanceled:(BOOL)flag;
@end


@interface PCAnimationHelperView : NSView
{
	CIImage *viewImage;
	NSView	*pendingView;
}

- (id)initWithView:(NSView*)aView endRect:(NSRect)aRect;

@end