#import <Cocoa/Cocoa.h>

@class CAAnimation;
@class CAMediaTimingFunction;

@interface PCViewTransition : NSObject
{
	NSView *iLayerView;
	NSView *iInView;
	NSView *iOutView;
	
	CFTimeInterval	iDuration;
	
	NSString	*iTransitionType;
	NSString	*iTransitionSubtype;
	CIFilter	*iTransitionFilter;
	CAAnimation *iProvidedAnimation;
	BOOL		iAnimateOutView;
	CAMediaTimingFunction *iTimingFunction;
	
	NSDictionary *iUserInfo;
	NSObject *iDelegate;
	PCViewTransition* iTransition;
}


@property CFTimeInterval duration;
@property (nonatomic, retain) NSObject* delegate;
@property (nonatomic, retain) NSView *inView;
@property (nonatomic, retain) NSView *outView;
@property (nonatomic, retain) NSString *transitionType;
@property (nonatomic, retain) NSString *transitionSubtype;
@property (nonatomic, retain) CIFilter *filter;
@property (nonatomic, retain) CAAnimation *animation;
@property (nonatomic, assign) BOOL	animateOutView;
@property (nonatomic, retain) CAMediaTimingFunction *timingFunction;
@property (nonatomic, copy) NSDictionary *userInfo;

+ (void)transitionToView:(NSView*)inView fromView:(NSView*)outView type:(NSString*)transitionType direction:(NSString*)transitionDirection;
+ (void)transitionToView:(NSView*)inView fromView:(NSView*)outView filter:(CIFilter*)filter;
+ (void)crossfadeToView:(NSView*)inView fromView:(NSView*)outView delegate:(id)aDelegate;
+ (void)zoomInView:(NSView*)inView fromView:(NSView*)outView;
+ (void)zoomInView:(NSView*)inView fromView:(NSView*)outView waitUntilDone:(BOOL)flag;
+ (void)zoomOutView:(NSView*)outView toView:(NSView*)inView;
+ (void)zoomOutView:(NSView*)outView toView:(NSView*)inView waitUntilDone:(BOOL)flag;

- (id)initWithIncomingView:(NSView*)inView outgoingView:(NSView*)outView type:(NSString*)transitionType subtype:(NSString*)transitionSubtype;
- (id)initWithIncomingView:(NSView*)inView outgoingView:(NSView*)outView filter:(CIFilter*)filter;

- (id)initWithIncomingView:(NSView*)inView outgoingView:(NSView*)outView animation:(CAAnimation*)animation;

- (void)runAnimation;
- (void)runAnimationWaitUntilDone:(BOOL)waitUntilDone;

@end


@interface NSObject (PCViewTransitionDelegate)

- (void)viewTransitionDidFinish:(PCViewTransition*)transition;

@end
