#import <PanicCore/PCTableEditingWindow.h>

/*
 *  PCWindow.h
 *
 *  Requires Mac OS X 10.5 or higher
 *
 *	Requires NSEvent-CommonKeys and NSWindow-Metrics categories.
 *
 *	Can post a notification when first responder changes as well as setting
 *	titlebar images and views.
 *	
 *
 *	-------------------------------------------------------------------
 *
 *
 */
 
 
extern NSString* const PCWindowFirstResponderDidChangeNotification;
extern NSString* const PCOptionKeyPressedNotification;
extern NSString* const PCOptionKeyReleasedNotification;


typedef enum {
	kPCWindowVerticalAlignmentTop = 1,
	kPCWindowVerticalAlignmentCenter = 0
} PCWindowVerticalAlignment;

@class PCTabBar;

@interface PCWindow : NSWindow
{
	IBOutlet PCTabBar *iTabBar; // needed for frame autosaving
	BOOL			postFirstResponderChangedNotifications;
	NSMutableArray* iTitleBarViews;
	BOOL			iTitleHidden;
}

@property(getter=isTitleHidden) BOOL titleHidden;
@property(retain) NSImage* titleBarImage;

- (void)addTitleBarView:(NSView*)view alignment:(PCWindowVerticalAlignment)alignment; // at end
- (void)removeTitleBarView:(NSView*)view;

- (void)setPostsFirstResponderChangedNotifications:(BOOL)flag;

@end
