#import <Carbon/Carbon.h>
#import <Cocoa/Cocoa.h>

@interface ResourceFile : NSObject 
{
	NSString* iPath;
	ResFileRefNum iRefNum;
}

+ (id)resourceFileAtPath:(NSString*)path;

- (void)dealloc;
- (id)initWithPath:(NSString*)path;

- (void)close;
- (OSErr)openForReading;
- (OSErr)openForWriting;
- (OSErr)openWithMode:(SInt8)mode;
- (NSString*)path;
- (Handle)resourceHandleOfType:(ResType)type withID:(ResID)resID;
- (NSData*)resourceDataOfType:(ResType)type withID:(ResID)resID;
- (void)setResourceData:(NSData*)data ofType:(ResType)type withID:(ResID)resID;

@end
