#include <stdint.h>

typedef uint8_t BYTE;
typedef uint16_t WORD;
typedef uint32_t DWORD;
typedef int32_t LONG;

inline static DWORD SwapDWORD(DWORD dw)
{
#if __BIG_ENDIAN__
	return ((dw & 0x000000FF) << 24) | ((dw & 0x0000FF00) << 8) | ((dw & 0x00FF0000) >> 8) | ((dw & 0xFF000000) >> 24);
#else
	return dw;
#endif
}

inline static WORD SwapWORD(WORD w)
{
#if __BIG_ENDIAN__
	return ((w & 0x00FF) << 8) | ((w & 0xFF00) >> 8);
#else
	return w;
#endif
}
