/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.Timer;

public class LedClockPanel
extends JPanel {
    private SimpleDateFormat formatter = new SimpleDateFormat();
    private Date currentDate;
    private LedTable ledTable = new LedTable(49, 9, 49, 9, 0);
    private Timer timer;
    private int hour;
    private int minute;
    private int second;
    private int day;
    private int month;
    private int year;
    private int secondTemp;
    private JPopupMenu popupMenu = new JPopupMenu();
    private JMenu menuColor = new JMenu("Color");
    private JMenuItem menuYellow = new JMenuItem("Yellow");
    private JMenuItem menuRed = new JMenuItem("Red");
    private JMenuItem menuGreen = new JMenuItem("Green");
    private JMenuItem menuBlue = new JMenuItem("Blue");
    private JMenuItem menuWhite = new JMenuItem("White");
    private JMenu menuHelp = new JMenu("Help");
    private JMenuItem menuSite = new JMenuItem("Visit web site");
    private JMenuItem menuAbout = new JMenuItem("About");
    private JMenuItem menuHide = new JMenuItem("Hide");
    private JMenuItem menuExit = new JMenuItem("Exit");
    private TimeUpdate timeUpdate = new TimeUpdate();
    private int absoluteCoordinateX;
    private int absoluteCoordinateY;
    private int relativeCoordinateXWhenMousePressed;
    private int relativeCoordinateYWhenMousePressed;
    private boolean mousePressedNow;
    private ConfigData configData = new ConfigData();

    public LedClockPanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.ledTable, "Center");
        this.addMouseListener(new MouseFunctions());
        this.addMouseMotionListener(new MouseMotionFunctions());
        this.timeUpdate.start();
        this.menuYellow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LedClockPanel.this.ledTable.setLedColor(0);
                LedClockPanel.this.saveFile();
            }
        });
        this.menuRed.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LedClockPanel.this.ledTable.setLedColor(2);
                LedClockPanel.this.saveFile();
            }
        });
        this.menuGreen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LedClockPanel.this.ledTable.setLedColor(4);
                LedClockPanel.this.saveFile();
            }
        });
        this.menuBlue.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LedClockPanel.this.ledTable.setLedColor(6);
                LedClockPanel.this.saveFile();
            }
        });
        this.menuWhite.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LedClockPanel.this.ledTable.setLedColor(8);
                LedClockPanel.this.saveFile();
            }
        });
        this.menuSite.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JOptionPane jOptionPane = new JOptionPane();
                JTextField jTextField = new JTextField();
                jTextField.setText("http://www.soft-collection.com");
                JOptionPane.showMessageDialog(null, jTextField, "Please visit web site!", 1);
            }
        });
        this.menuAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JOptionPane.showMessageDialog(null, "Led Digital Clock v1.15", "About", 1);
            }
        });
        this.menuHide.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LedClockWindow.windowMustMinimized = true;
            }
        });
        this.menuExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        this.popupMenu.add(this.menuColor);
        this.menuColor.add(this.menuYellow);
        this.menuColor.add(this.menuRed);
        this.menuColor.add(this.menuGreen);
        this.menuColor.add(this.menuBlue);
        this.menuColor.add(this.menuWhite);
        this.popupMenu.add(this.menuHelp);
        this.menuHelp.add(this.menuSite);
        this.menuHelp.add(this.menuAbout);
        this.popupMenu.add(this.menuHide);
        this.popupMenu.add(this.menuExit);
        this.openFile();
        LedClockWindow.windowMustBeShown = true;
    }

    public void drawTime() {
        this.currentDate = new Date();
        this.formatter.applyPattern("HH");
        this.hour = Integer.parseInt(this.formatter.format(this.currentDate).toString());
        this.formatter.applyPattern("mm");
        this.minute = Integer.parseInt(this.formatter.format(this.currentDate).toString());
        this.formatter.applyPattern("ss");
        this.second = Integer.parseInt(this.formatter.format(this.currentDate).toString());
        this.formatter.applyPattern("dd");
        this.day = Integer.parseInt(this.formatter.format(this.currentDate).toString());
        this.formatter.applyPattern("MM");
        this.month = Integer.parseInt(this.formatter.format(this.currentDate).toString());
        this.formatter.applyPattern("yyyy");
        this.year = Integer.parseInt(this.formatter.format(this.currentDate).toString());
        if (this.secondTemp != this.second) {
            this.setLetter(0, this.hour / 10 + 16);
            this.setLetter(1, this.hour % 10 + 16);
            this.setLetter(2, 26);
            this.setLetter(3, this.minute / 10 + 16);
            this.setLetter(4, this.minute % 10 + 16);
            this.setLetter(5, 26);
            this.setLetter(6, this.second / 10 + 16);
            this.setLetter(7, this.second % 10 + 16);
            this.ledTable.updateClock();
            this.secondTemp = this.second;
        }
    }

    public void setLetter(int n, int n2) {
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 8; ++j) {
                this.ledTable.ledTableStateArray[n * 6 + i + 1][j + 1] = Font.fontArray[n2 * 5 + i][j];
            }
        }
    }

    public void saveFile() {
        this.configData.clockXCoordinate = this.getLocationOnScreen().x;
        this.configData.clockYCoordinate = this.getLocationOnScreen().y;
        this.configData.clockLedColor = this.ledTable.ledColor;
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream("LedClock.cfg"));
            objectOutputStream.writeObject(this.configData);
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void openFile() {
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream("LedClock.cfg"));
            try {
                this.configData = (ConfigData)objectInputStream.readObject();
                LedClockWindow.setCoordinateX = this.configData.clockXCoordinate;
                LedClockWindow.setCoordinateY = this.configData.clockYCoordinate;
                this.ledTable.setLedColor(this.configData.clockLedColor);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            objectInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class MouseMotionFunctions
    extends MouseMotionAdapter {
        private MouseMotionFunctions() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (LedClockPanel.this.mousePressedNow) {
                LedClockPanel.this.absoluteCoordinateX = LedClockPanel.this.getLocationOnScreen().x + mouseEvent.getX();
                LedClockPanel.this.absoluteCoordinateY = LedClockPanel.this.getLocationOnScreen().y + mouseEvent.getY();
                LedClockWindow.setCoordinateX = LedClockPanel.this.absoluteCoordinateX - LedClockPanel.this.relativeCoordinateXWhenMousePressed;
                LedClockWindow.setCoordinateY = LedClockPanel.this.absoluteCoordinateY - LedClockPanel.this.relativeCoordinateYWhenMousePressed;
            }
        }
    }

    private class MouseFunctions
    extends MouseAdapter {
        private MouseFunctions() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 1) {
                LedClockPanel.this.mousePressedNow = true;
                LedClockPanel.this.relativeCoordinateXWhenMousePressed = mouseEvent.getX();
                LedClockPanel.this.relativeCoordinateYWhenMousePressed = mouseEvent.getY();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            LedClockPanel.this.mousePressedNow = false;
            LedClockPanel.this.saveFile();
            if (mouseEvent.isPopupTrigger()) {
                LedClockPanel.this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    private class TimeUpdate
    extends Thread {
        private TimeUpdate() {
        }

        public void run() {
            while (true) {
                LedClockPanel.this.drawTime();
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

