/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class LedTable
extends JPanel {
    private Image leds;
    private Image emptyClock;
    public static final boolean OFF = false;
    public static final boolean ON = true;
    public static final int YELLOW = 0;
    public static final int RED = 2;
    public static final int GREEN = 4;
    public static final int BLUE = 6;
    public static final int WHITE = 8;
    public static int clockWidth;
    public static int clockHeight;
    public static int ledWidth;
    public static int ledHeight;
    private int ledsPerWidth = 10;
    private int ledsPerHeight = 10;
    private int ledsPerWidthToBeShowed = 10;
    private int ledsPerHeightToBeShowed = 10;
    public boolean[][] ledTableStateArray;
    public int[][] ledTableColorArray;
    public int ledColor;

    public LedTable(int n, int n2) {
        this.ledsPerWidth = n;
        this.ledsPerHeight = n2;
        this.InitLedTable();
    }

    public LedTable(int n, int n2, int n3, int n4) {
        this.ledsPerWidth = n;
        this.ledsPerHeight = n2;
        this.ledsPerWidthToBeShowed = n3;
        this.ledsPerHeightToBeShowed = n4;
        this.InitLedTable();
    }

    public LedTable(int n, int n2, int n3, int n4, int n5) {
        this.ledsPerWidth = n;
        this.ledsPerHeight = n2;
        this.ledsPerWidthToBeShowed = n3;
        this.ledsPerHeightToBeShowed = n4;
        this.InitLedTable();
        this.setLedColor(n5);
    }

    private void InitLedTable() {
        if (this.ledsPerWidthToBeShowed > this.ledsPerWidth) {
            this.ledsPerWidthToBeShowed = this.ledsPerWidth;
        }
        if (this.ledsPerHeightToBeShowed > this.ledsPerHeight) {
            this.ledsPerHeightToBeShowed = this.ledsPerHeight;
        }
        this.ledTableStateArray = new boolean[this.ledsPerWidth][this.ledsPerHeight];
        this.ledTableColorArray = new int[this.ledsPerWidth][this.ledsPerHeight];
        this.setLedColor(0);
        this.emptyClock = new ImageIcon(EmptyClockImage.emptyClock).getImage();
        clockWidth = this.emptyClock.getWidth(this);
        clockHeight = this.emptyClock.getHeight(this);
        this.leds = new ImageIcon(LedImage.leds).getImage();
        ledWidth = this.leds.getWidth(this) / 10;
        ledHeight = this.leds.getHeight(this);
        this.setPreferredSize(new Dimension(clockWidth, clockHeight));
        this.setOpaque(false);
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.drawLedTable(graphics);
    }

    private void drawLedTable(Graphics graphics) {
        graphics.drawImage(this.emptyClock, 0, 0, this);
        for (int i = 0; i < this.ledsPerWidth; ++i) {
            for (int j = 0; j < this.ledsPerHeight; ++j) {
                graphics.drawImage(this.leds, 30 + i * ledWidth, 30 + j * ledHeight, 30 + i * ledWidth + ledWidth, 30 + j * ledHeight + ledHeight, (this.ledTableColorArray[i][j] + (!this.ledTableStateArray[i][j] ? 0 : 1)) * ledWidth, 0, (this.ledTableColorArray[i][j] + (!this.ledTableStateArray[i][j] ? 0 : 1)) * ledWidth + ledWidth, ledHeight, this);
            }
        }
    }

    public void setLedColor(int n) {
        this.ledColor = n;
        for (int i = 0; i < this.ledsPerWidth; ++i) {
            for (int j = 0; j < this.ledsPerHeight; ++j) {
                this.ledTableColorArray[i][j] = n;
            }
        }
        this.updateClock();
    }

    public void updateClock() {
        if (this.getParent() != null) {
            this.getParent().repaint();
        }
        this.repaint();
    }
}

