/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

class AlcoveWizard
extends JDialog
implements ActionListener {
    private int side;
    private int level;
    private int x;
    private int y;
    private MapData data;
    private MultWallSwitchData alcoveswitch;
    private JToggleButton onealc;
    private JToggleButton vialtar;
    private JToggleButton manyalc;
    private JToggleButton[] sidebutton = new JToggleButton[4];
    private JLabel hasswitch;
    private DMEditor dmed;
    public static final String[] sides = new String[]{"N", "W", "S", "E"};

    public AlcoveWizard(DMEditor dMEditor) {
        super(dMEditor, "Alcove Wizard", true);
        this.dmed = dMEditor;
        this.level = this.level;
        this.x = this.x;
        this.y = this.y;
        this.setDefaultCloseOperation(2);
        this.setSize(500, 300);
        this.setLocationRelativeTo(dMEditor);
        Container container = this.getContentPane();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.onealc = new JToggleButton("1-Sided");
        this.vialtar = new JToggleButton("VI Altar");
        this.manyalc = new JToggleButton("4-Sided");
        this.onealc.addActionListener(this);
        this.vialtar.addActionListener(this);
        this.manyalc.addActionListener(this);
        buttonGroup.add(this.onealc);
        buttonGroup.add(this.vialtar);
        buttonGroup.add(this.manyalc);
        jPanel.add(this.onealc);
        jPanel.add(this.vialtar);
        jPanel.add(this.manyalc);
        this.onealc.setSelected(true);
        JPanel jPanel2 = new JPanel();
        ButtonGroup buttonGroup2 = new ButtonGroup();
        this.sidebutton[0] = new JToggleButton("North");
        this.sidebutton[1] = new JToggleButton("West");
        this.sidebutton[2] = new JToggleButton("South");
        this.sidebutton[3] = new JToggleButton("East");
        this.sidebutton[0].addActionListener(this);
        this.sidebutton[1].addActionListener(this);
        this.sidebutton[2].addActionListener(this);
        this.sidebutton[3].addActionListener(this);
        buttonGroup2.add(this.sidebutton[0]);
        buttonGroup2.add(this.sidebutton[1]);
        buttonGroup2.add(this.sidebutton[2]);
        buttonGroup2.add(this.sidebutton[3]);
        JPanel jPanel3 = new JPanel(new GridLayout(3, 3));
        jPanel3.add(new JLabel());
        jPanel3.add(this.sidebutton[0]);
        jPanel3.add(new JLabel());
        jPanel3.add(this.sidebutton[1]);
        jPanel3.add(new JLabel());
        jPanel3.add(this.sidebutton[3]);
        jPanel3.add(new JLabel());
        jPanel3.add(this.sidebutton[2]);
        jPanel3.add(new JLabel());
        jPanel2.add(jPanel3);
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), "Opening faces:"));
        this.sidebutton[2].setSelected(true);
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayout(3, 1));
        this.hasswitch = new JLabel("No Switch");
        JButton jButton = new JButton("Add/Edit Switch");
        JButton jButton2 = new JButton("Remove Switch");
        jButton.addActionListener(this);
        jButton2.addActionListener(this);
        jPanel5.add(this.hasswitch);
        jPanel5.add(jButton);
        jPanel5.add(jButton2);
        jPanel4.add(jPanel5);
        JPanel jPanel6 = new JPanel();
        jPanel6.add(jPanel2);
        JPanel jPanel7 = new JPanel();
        JButton jButton3 = new JButton("Done");
        JButton jButton4 = new JButton("Cancel");
        jButton3.addActionListener(this);
        jButton4.addActionListener(this);
        jPanel7.add(jButton4);
        jPanel7.add(jButton3);
        container.add("North", jPanel);
        container.add("Center", jPanel6);
        container.add("South", jPanel7);
        container.add("East", jPanel4);
        this.dispose();
    }

    public void setData(MapData mapData, int n, int n2, int n3) {
        this.level = n;
        this.x = n2;
        this.y = n3;
        if (mapData.mapchar == '[') {
            this.manyalc.doClick();
            if (((AlcoveData)mapData).isSwitch) {
                this.alcoveswitch = ((AlcoveData)mapData).alcoveswitchdata;
                this.hasswitch.setText("Has Switch");
            } else {
                this.alcoveswitch = null;
                this.hasswitch.setText("No Switch");
            }
        } else if (mapData instanceof OneAlcoveData) {
            if (mapData.mapchar == ']') {
                this.onealc.doClick();
            } else {
                this.vialtar.doClick();
            }
            this.sidebutton[(((OneAlcoveData)mapData).side + 2) % 4].doClick();
            if (((OneAlcoveData)mapData).isSwitch) {
                this.alcoveswitch = ((OneAlcoveData)mapData).alcoveswitchdata;
                this.hasswitch.setText("Has Switch");
            } else {
                this.alcoveswitch = null;
                this.hasswitch.setText("No Switch");
            }
        } else {
            this.alcoveswitch = null;
            this.hasswitch.setText("No Switch");
        }
        this.show();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("4-Sided")) {
            this.sidebutton[0].setEnabled(false);
            this.sidebutton[1].setEnabled(false);
            this.sidebutton[2].setEnabled(false);
            this.sidebutton[3].setEnabled(false);
        } else if (actionEvent.getActionCommand().equals("1-Sided") || actionEvent.getActionCommand().equals("VI Altar")) {
            this.sidebutton[0].setEnabled(true);
            this.sidebutton[1].setEnabled(true);
            this.sidebutton[2].setEnabled(true);
            this.sidebutton[3].setEnabled(true);
        } else if (actionEvent.getActionCommand().equals("North")) {
            this.side = 2;
        } else if (actionEvent.getActionCommand().equals("South")) {
            this.side = 0;
        } else if (actionEvent.getActionCommand().equals("East")) {
            this.side = 1;
        } else if (actionEvent.getActionCommand().equals("West")) {
            this.side = 3;
        } else if (actionEvent.getActionCommand().equals("Done")) {
            this.data = this.onealc.isSelected() ? (this.alcoveswitch == null ? new OneAlcoveData(this.side) : new OneAlcoveData(this.side, this.alcoveswitch)) : (this.vialtar.isSelected() ? (this.alcoveswitch == null ? new AltarData(this.side) : new AltarData(this.side, this.alcoveswitch)) : (this.alcoveswitch == null ? new AlcoveData() : new AlcoveData(this.alcoveswitch)));
            this.dispose();
        } else if (actionEvent.getActionCommand().equals("Cancel")) {
            this.data = null;
            this.dispose();
        } else if (actionEvent.getActionCommand().equals("Add/Edit Switch")) {
            MultWallSwitchData multWallSwitchData;
            int n = 0;
            if (this.manyalc.isSelected()) {
                n = 1;
            }
            if ((multWallSwitchData = (MultWallSwitchData)new MultWallSwitchWizard(this.dmed, this.alcoveswitch, this.level, this.x, this.y, false, n, this.side).getData()) != null) {
                this.alcoveswitch = multWallSwitchData;
                this.hasswitch.setText("Has Switch");
            }
        } else if (actionEvent.getActionCommand().equals("Remove Switch")) {
            if (this.hasswitch.getText().equals("No Switch")) {
                return;
            }
            this.alcoveswitch = null;
            this.hasswitch.setText("No Switch");
        }
    }

    public MapData getData() {
        return this.data;
    }
}

