/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;

public class Choice {
    public Vector actions;
    public Item needitem;
    public boolean takeitem;
    public boolean visible = true;
    public boolean shouldshow;
    public boolean autotrigger;
    public boolean needdead;
    public int[] needskill;
    public String choicename;
    public int needmons = -1;
    public int needmonslvl;

    public Choice(String string) {
        this.choicename = string;
    }

    public static Choice makeLeave() {
        Choice choice = new Choice("Leave");
        choice.actions = new Vector();
        choice.actions.add(new Action(0, null, -1));
        return choice;
    }

    public String toString() {
        return this.choicename + "  < " + this.actions.size() + " Action(s) >";
    }

    public void save(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeUTF(this.choicename);
        objectOutputStream.writeBoolean(this.visible);
        objectOutputStream.writeBoolean(this.autotrigger);
        if (this.needitem != null) {
            objectOutputStream.writeBoolean(true);
            objectOutputStream.writeObject(this.needitem);
            objectOutputStream.writeBoolean(this.takeitem);
        } else {
            objectOutputStream.writeBoolean(false);
        }
        if (this.needskill != null) {
            objectOutputStream.writeBoolean(true);
            objectOutputStream.writeObject(this.needskill);
        } else {
            objectOutputStream.writeBoolean(false);
        }
        objectOutputStream.writeInt(this.needmons);
        if (this.needmons >= 0) {
            objectOutputStream.writeInt(this.needmonslvl);
            objectOutputStream.writeBoolean(this.needdead);
        }
        objectOutputStream.writeInt(this.actions.size());
        for (int i = 0; i < this.actions.size(); ++i) {
            Action action = (Action)this.actions.get(i);
            objectOutputStream.writeInt(action.actiontype);
            if (action.actiontype == 4) {
                ((HeroData)action.action).save(objectOutputStream);
            } else if (action.actiontype == 12) {
                ((SpecialAbility)action.action).save(objectOutputStream);
            } else {
                objectOutputStream.writeObject(action.action);
            }
            objectOutputStream.writeInt(action.reusable);
        }
    }

    public void load(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.visible = objectInputStream.readBoolean();
        this.autotrigger = objectInputStream.readBoolean();
        if (objectInputStream.readBoolean()) {
            this.needitem = (Item)objectInputStream.readObject();
            this.takeitem = objectInputStream.readBoolean();
        }
        if (objectInputStream.readBoolean()) {
            this.needskill = (int[])objectInputStream.readObject();
        }
        this.needmons = objectInputStream.readInt();
        if (this.needmons >= 0) {
            this.needmonslvl = objectInputStream.readInt();
            this.needdead = objectInputStream.readBoolean();
        }
        this.actions = new Vector();
        int n = objectInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            Action action = new Action();
            action.actiontype = objectInputStream.readInt();
            if (action.actiontype == 4) {
                action.action = new HeroData(objectInputStream.readUTF());
                ((HeroData)action.action).load(objectInputStream);
            } else {
                action.action = action.actiontype == 12 ? new SpecialAbility(objectInputStream) : objectInputStream.readObject();
            }
            action.reusable = objectInputStream.readInt();
            this.actions.add(action);
        }
    }
}

