/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

class DMMap
extends JPanel
implements MouseListener {
    public static final ImageIcon WallIconS = new ImageIcon("Icons" + File.separator + "wall-s.gif");
    public static final ImageIcon DoorIconS = new ImageIcon("Icons" + File.separator + "door-s.gif");
    public static final ImageIcon FakeWallIconS = new ImageIcon("Icons" + File.separator + "fakewall-s.gif");
    public static final ImageIcon AltarIconS = new ImageIcon("Icons" + File.separator + "altar-s.gif");
    public static final ImageIcon AlcoveIconS = new ImageIcon("Icons" + File.separator + "alcove-s.gif");
    public static final ImageIcon FountainIconS = new ImageIcon("Icons" + File.separator + "fountain-s.gif");
    public static final ImageIcon StairsDownIconS = new ImageIcon("Icons" + File.separator + "stairsdown-s.gif");
    public static final ImageIcon StairsUpIconS = new ImageIcon("Icons" + File.separator + "stairsup-s.gif");
    public static final ImageIcon TeleportIconS = new ImageIcon("Icons" + File.separator + "teleport-s.gif");
    public static final ImageIcon PitIconS = new ImageIcon("Icons" + File.separator + "pit-s.gif");
    public static final ImageIcon MirrorIconS = new ImageIcon("Icons" + File.separator + "mirror-s.gif");
    public static final ImageIcon WritingIconS = new ImageIcon("Icons" + File.separator + "writing-s.gif");
    public static final ImageIcon LauncherIconS = new ImageIcon("Icons" + File.separator + "launcher-s.gif");
    public static final ImageIcon GeneratorIconS = new ImageIcon("Icons" + File.separator + "generator-s.gif");
    public static final ImageIcon WallSwitchIconS = new ImageIcon("Icons" + File.separator + "wallswitch-s.gif");
    public static final ImageIcon FloorSwitchIconS = new ImageIcon("Icons" + File.separator + "floorswitch-s.gif");
    public static final ImageIcon SconceIconS = new ImageIcon("Icons" + File.separator + "sconce-s.gif");
    public static final ImageIcon DecorationIconS = new ImageIcon("Icons" + File.separator + "decoration-s.gif");
    public static final ImageIcon FDecorationIconS = new ImageIcon("Icons" + File.separator + "fdecoration-s.gif");
    public static final ImageIcon PillarIconS = new ImageIcon("Icons" + File.separator + "pillar-s.gif");
    public static final ImageIcon InvisibleWallIconS = new ImageIcon("Icons" + File.separator + "invisiblewall-s.gif");
    public static final ImageIcon EventIconS = new ImageIcon("Icons" + File.separator + "event-s.gif");
    public static final ImageIcon StormIconS = new ImageIcon("Icons" + File.separator + "stormbringer-s.gif");
    public static final ImageIcon GemIconS = new ImageIcon("Icons" + File.separator + "powergem-s.gif");
    public static final ImageIcon FulYaIconS = new ImageIcon("Icons" + File.separator + "fulya-s.gif");
    private dmnew dm;
    private boolean needupdate = true;
    private int levels;
    private int width;
    private int height;
    public int currentlevel;
    public char[][][] map;
    private Dimension smalldim;
    private Font smallfont;
    private Color floorcolor;
    private Color greycolor;
    private Graphics2D g;
    private BufferedImage pic;

    public DMMap(dmnew dmnew2, int n, int n2, int n3, char[][][] cArray) {
        super(false);
        this.dm = dmnew2;
        this.floorcolor = new Color(40, 30, 30);
        this.greycolor = new Color(60, 60, 60);
        this.smalldim = new Dimension(n2 * 17, n3 * 17);
        this.setBackground(Color.black);
        this.smallfont = dmnew.dungfont.deriveFont(6.0f);
        this.pic = new BufferedImage(n2 * 17, n3 * 17, 3);
        this.g = this.pic.createGraphics();
        this.setMap(n, n2, n3, cArray);
        this.addMouseListener(this);
    }

    public void updateSize() {
        int n;
        int n2 = this.dm.getSize().width - 30;
        if (n2 < this.width * 17) {
            n2 = this.width * 17;
        }
        if ((n = this.dm.getSize().height - 30) < this.height * 17) {
            n = this.height * 17;
        }
        this.setPreferredSize(new Dimension(n2, n));
        this.setMaximumSize(new Dimension(n2, n));
        this.setMinimumSize(new Dimension(n2, n));
    }

    public void setMap(int n, int n2, int n3, char[][][] cArray) {
        this.levels = n;
        if (cArray != null) {
            this.map = cArray;
        }
        if (this.width != n2 || this.height != n3) {
            this.width = n2;
            this.height = n3;
            this.smalldim = new Dimension(n2 * 17, n3 * 17);
            if (n2 > this.pic.getWidth(null) / 17 || n3 > this.pic.getHeight(null) / 17) {
                this.pic.flush();
                this.g.dispose();
                this.pic = null;
                this.pic = new BufferedImage(n2 * 17, n3 * 17, 3);
                this.g = this.pic.createGraphics();
                this.g.setFont(this.smallfont);
            }
        }
        this.currentlevel = dmnew.level;
        if (cArray == null) {
            this.makeMap();
        }
        this.needupdate = true;
        this.updateSize();
        this.repaint();
    }

    private void makeMap() {
        if (this.map == null || this.map.length != this.levels || this.map[0].length != this.width || this.map[0][0].length != this.height) {
            this.map = new char[this.levels][this.width][this.height];
        }
        for (int i = 0; i < this.levels; ++i) {
            for (int j = 0; j < this.width; ++j) {
                for (int k = 0; k < this.height; ++k) {
                    this.map[i][j][k] = 63;
                }
            }
        }
    }

    public void doMap() {
        int n;
        int n2;
        int n3;
        int n4;
        block23: {
            block34: {
                block35: {
                    block32: {
                        block33: {
                            block30: {
                                block31: {
                                    block29: {
                                        block28: {
                                            block27: {
                                                block26: {
                                                    block24: {
                                                        block25: {
                                                            block22: {
                                                                n4 = dmnew.level;
                                                                n3 = dmnew.partyx;
                                                                n2 = dmnew.partyy;
                                                                n = 48;
                                                                if (dmnew.DungeonMap[n4][n3][n2].mapchar != 'd') break block22;
                                                                n = 100;
                                                                break block23;
                                                            }
                                                            if (dmnew.DungeonMap[n4][n3][n2].mapchar != 't') break block24;
                                                            if (this.map[n4][n3][n2] == 't') break block25;
                                                            if (!((Teleport)dmnew.DungeonMap[n4][n3][n2]).isVisible) break block24;
                                                            if (!((Teleport)dmnew.DungeonMap[n4][n3][n2]).isOn) break block24;
                                                        }
                                                        n = 116;
                                                        break block23;
                                                    }
                                                    if (dmnew.DungeonMap[n4][n3][n2].mapchar != '>') break block26;
                                                    n = ((Stairs)dmnew.DungeonMap[n4][n3][n2]).goesUp ? 60 : 62;
                                                    break block23;
                                                }
                                                if (dmnew.DungeonMap[n4][n3][n2].mapchar != '2') break block27;
                                                n = 50;
                                                break block23;
                                            }
                                            if (dmnew.DungeonMap[n4][n3][n2].mapchar != 'F') break block28;
                                            n = 70;
                                            break block23;
                                        }
                                        if (dmnew.DungeonMap[n4][n3][n2].mapchar != 'g') break block29;
                                        if (((Generator)dmnew.DungeonMap[n4][n3][n2]).monster.number != 10) break block29;
                                        n = 103;
                                        break block23;
                                    }
                                    if (dmnew.DungeonMap[n4][n3][n2].mapchar != 's') break block30;
                                    if (this.map[n4][n3][n2] == 's') break block31;
                                    if (!((FloorSwitch)dmnew.DungeonMap[n4][n3][n2]).haspic) break block30;
                                }
                                n = 115;
                                break block23;
                            }
                            if (dmnew.DungeonMap[n4][n3][n2].mapchar != 'S') break block32;
                            if (this.map[n4][n3][n2] == 's') break block33;
                            if (!((MultFloorSwitch2)dmnew.DungeonMap[n4][n3][n2]).haspic) break block32;
                        }
                        n = 115;
                        break block23;
                    }
                    if (dmnew.DungeonMap[n4][n3][n2].mapchar != 'p') break block34;
                    if (this.map[n4][n3][n2] == 'p') break block35;
                    if (((Pit)dmnew.DungeonMap[n4][n3][n2]).isOpen) break block35;
                    if (!((Pit)dmnew.DungeonMap[n4][n3][n2]).isIllusionary) break block23;
                }
                n = 112;
                break block23;
            }
            if (dmnew.DungeonMap[n4][n3][n2].mapchar == 'E') {
                n = 69;
            }
        }
        this.update(n4, n3, n2, (char)n);
        int n5 = n3;
        int n6 = n2;
        if (dmnew.facing == 0) {
            --n6;
        } else if (dmnew.facing == 1) {
            --n5;
        } else if (dmnew.facing == 2) {
            ++n6;
        } else {
            ++n5;
        }
        this.checkMap(n4, n5, n6, dmnew.facing);
        n5 = n3;
        n6 = n2;
        if (dmnew.facing == 0) {
            --n5;
        } else if (dmnew.facing == 1) {
            ++n6;
        } else if (dmnew.facing == 2) {
            ++n5;
        } else {
            --n6;
        }
        this.checkMap(n4, n5, n6, (dmnew.facing + 1) % 4);
        n5 = n3;
        n6 = n2;
        if (dmnew.facing == 0) {
            ++n5;
        } else if (dmnew.facing == 1) {
            --n6;
        } else if (dmnew.facing == 2) {
            --n5;
        } else {
            ++n6;
        }
        this.checkMap(n4, n5, n6, (dmnew.facing + 3) % 4);
        if (dmnew.SHOWPARTYMAP) {
            this.needupdate = true;
        }
    }

    private void checkMap(int n, int n2, int n3, int n4) {
        int n5;
        block50: {
            block60: {
                block61: {
                    block58: {
                        block59: {
                            block56: {
                                block57: {
                                    block55: {
                                        block54: {
                                            block52: {
                                                block53: {
                                                    block51: {
                                                        block49: {
                                                            if (n2 < 0 || n3 < 0 || n2 >= this.width || n3 >= this.width) {
                                                                return;
                                                            }
                                                            n5 = 48;
                                                            if (!(dmnew.DungeonMap[n][n2][n3] instanceof Wall)) break block49;
                                                            n5 = 49;
                                                            if (dmnew.DungeonMap[n][n2][n3] instanceof SidedWall) {
                                                                if (dmnew.DungeonMap[n][n2][n3].mapchar == this.map[n][n2][n3]) {
                                                                    n5 = this.map[n][n2][n3];
                                                                } else if (((SidedWall)dmnew.DungeonMap[n][n2][n3]).side == n4) {
                                                                    if (dmnew.DungeonMap[n][n2][n3].mapchar == '>') {
                                                                        n5 = ((Stairs)dmnew.DungeonMap[n][n2][n3]).goesUp ? 60 : 62;
                                                                    } else if (dmnew.DungeonMap[n][n2][n3].mapchar == 'w') {
                                                                        n5 = 119;
                                                                    } else if (dmnew.DungeonMap[n][n2][n3].mapchar == 'f') {
                                                                        n5 = 102;
                                                                    } else if (dmnew.DungeonMap[n][n2][n3].mapchar == ']') {
                                                                        n5 = 93;
                                                                    } else if (dmnew.DungeonMap[n][n2][n3].mapchar == 'a') {
                                                                        n5 = 97;
                                                                    }
                                                                }
                                                            } else if (dmnew.DungeonMap[n][n2][n3] instanceof SidedWall2) {
                                                                if (dmnew.DungeonMap[n][n2][n3].mapchar == this.map[n][n2][n3]) {
                                                                    n5 = this.map[n][n2][n3];
                                                                } else if (((SidedWall2)dmnew.DungeonMap[n][n2][n3]).side == n4) {
                                                                    if (dmnew.DungeonMap[n][n2][n3].mapchar == 'D') {
                                                                        n5 = 68;
                                                                    } else if (dmnew.DungeonMap[n][n2][n3].mapchar == '/') {
                                                                        int n6 = ((WallSwitch)dmnew.DungeonMap[n][n2][n3]).picnumber;
                                                                        if (n6 != 2 && n6 != 6 && n6 != 7 && n6 != 8 && n6 != 14 && n6 != 15) {
                                                                            n5 = 47;
                                                                        } else if (this.map[n][n2][n3] == '/') {
                                                                            n5 = 47;
                                                                        } else if (n6 != 2) {
                                                                            n5 = 68;
                                                                        }
                                                                    } else if (dmnew.DungeonMap[n][n2][n3].mapchar == '\\') {
                                                                        int n7 = ((MultWallSwitch2)dmnew.DungeonMap[n][n2][n3]).picnumber;
                                                                        if (n7 != 2 && n7 != 6 && n7 != 7 && n7 != 8 && n7 != 14 && n7 != 15) {
                                                                            n5 = 47;
                                                                        } else if (this.map[n][n2][n3] == '/') {
                                                                            n5 = 47;
                                                                        } else if (n7 != 2) {
                                                                            n5 = 68;
                                                                        }
                                                                    } else if (dmnew.DungeonMap[n][n2][n3].mapchar == '}') {
                                                                        n5 = 125;
                                                                    } else if (dmnew.DungeonMap[n][n2][n3].mapchar == 'm') {
                                                                        n5 = 109;
                                                                    }
                                                                }
                                                            } else if (dmnew.DungeonMap[n][n2][n3].mapchar == '2' && this.map[n][n2][n3] == '2') {
                                                                n5 = 50;
                                                            } else if (dmnew.DungeonMap[n][n2][n3].mapchar == '[') {
                                                                n5 = 93;
                                                            } else if (dmnew.DungeonMap[n][n2][n3].mapchar == 'P') {
                                                                n5 = 80;
                                                            } else if (dmnew.DungeonMap[n][n2][n3].mapchar == 'i') {
                                                                n5 = this.map[n][n2][n3] == 'i' ? 105 : 48;
                                                            }
                                                            break block50;
                                                        }
                                                        if (dmnew.DungeonMap[n][n2][n3].mapchar != 'd') break block51;
                                                        n5 = 100;
                                                        break block50;
                                                    }
                                                    if (dmnew.DungeonMap[n][n2][n3].mapchar != 't') break block52;
                                                    if (this.map[n][n2][n3] == 't') break block53;
                                                    if (!((Teleport)dmnew.DungeonMap[n][n2][n3]).isVisible) break block52;
                                                    if (!((Teleport)dmnew.DungeonMap[n][n2][n3]).isOn) break block52;
                                                }
                                                n5 = 116;
                                                break block50;
                                            }
                                            if (dmnew.DungeonMap[n][n2][n3].mapchar != 'F') break block54;
                                            n5 = 70;
                                            break block50;
                                        }
                                        if (dmnew.DungeonMap[n][n2][n3].mapchar != 'g') break block55;
                                        if (((Generator)dmnew.DungeonMap[n][n2][n3]).monster.number != 10) break block55;
                                        n5 = 103;
                                        break block50;
                                    }
                                    if (dmnew.DungeonMap[n][n2][n3].mapchar != 's') break block56;
                                    if (this.map[n][n2][n3] == 's') break block57;
                                    if (!((FloorSwitch)dmnew.DungeonMap[n][n2][n3]).haspic) break block56;
                                }
                                n5 = 115;
                                break block50;
                            }
                            if (dmnew.DungeonMap[n][n2][n3].mapchar != 'S') break block58;
                            if (this.map[n][n2][n3] == 's') break block59;
                            if (!((MultFloorSwitch2)dmnew.DungeonMap[n][n2][n3]).haspic) break block58;
                        }
                        n5 = 115;
                        break block50;
                    }
                    if (dmnew.DungeonMap[n][n2][n3].mapchar != 'p') break block60;
                    if (this.map[n][n2][n3] == 'p') break block61;
                    if (((Pit)dmnew.DungeonMap[n][n2][n3]).isOpen) break block61;
                    if (!((Pit)dmnew.DungeonMap[n][n2][n3]).isIllusionary) break block50;
                }
                n5 = 112;
                break block50;
            }
            if (dmnew.DungeonMap[n][n2][n3].mapchar == 'E' && this.map[n][n2][n3] == 'E') {
                n5 = 69;
            }
        }
        this.update(n, n2, n3, (char)n5);
    }

    public void update(int n, int n2, int n3, char c) {
        if (this.map[n][n2][n3] == c) {
            return;
        }
        this.map[n][n2][n3] = c;
        this.needupdate = true;
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
        if (!this.needupdate) {
            graphics.drawImage(this.pic, this.getSize().width / 2 - this.width * 17 / 2, this.getSize().height / 2 - this.height * 17 / 2, this);
            return;
        }
        this.currentlevel = dmnew.level;
        this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.g.setColor(this.floorcolor);
        this.g.fillRect(0, 0, this.width * 17, this.height * 17);
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                n = j * 17;
                n2 = i * 17;
                Image image = null;
                if (this.map[this.currentlevel][j][i] == '?') {
                    this.g.setColor(this.greycolor);
                    this.g.fillRect(n, n2, 17, 17);
                } else {
                    image = this.getPic(this.currentlevel, j, i);
                }
                if (image != null) {
                    this.g.drawImage(image, n, n2, null);
                }
                if (!dmnew.SHOWPARTYMAP) continue;
                if (dmnew.level != this.currentlevel) continue;
                if (dmnew.partyx != j) continue;
                if (dmnew.partyy != i) continue;
                this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                this.g.setColor(Color.green);
                this.g.drawArc(n + 1, n2 + 1, 14, 14, 45, 90);
                this.g.setColor(Color.yellow);
                this.g.drawArc(n + 1, n2 + 1, 14, 14, 135, 90);
                this.g.setColor(Color.red);
                this.g.drawArc(n + 1, n2 + 1, 14, 14, 225, 90);
                this.g.setColor(Color.blue);
                this.g.drawArc(n + 1, n2 + 1, 14, 14, 315, 90);
                this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
        }
        this.needupdate = false;
        graphics.drawImage(this.pic, this.getSize().width / 2 - this.width * 17 / 2, this.getSize().height / 2 - this.height * 17 / 2, this);
    }

    private Image getPic(int n, int n2, int n3) {
        if (this.map[n][n2][n3] == '1') {
            return WallIconS.getImage();
        }
        if (this.map[n][n2][n3] == '0') {
            return null;
        }
        if (this.map[n][n2][n3] == '2') {
            return FakeWallIconS.getImage();
        }
        if (this.map[n][n2][n3] == '>') {
            return StairsDownIconS.getImage();
        }
        if (this.map[n][n2][n3] == '<') {
            return StairsUpIconS.getImage();
        }
        if (this.map[n][n2][n3] == 'd') {
            return DoorIconS.getImage();
        }
        if (this.map[n][n2][n3] == 's') {
            return FloorSwitchIconS.getImage();
        }
        if (this.map[n][n2][n3] == '/') {
            return WallSwitchIconS.getImage();
        }
        if (this.map[n][n2][n3] == 't') {
            return TeleportIconS.getImage();
        }
        if (this.map[n][n2][n3] == ']') {
            return AlcoveIconS.getImage();
        }
        if (this.map[n][n2][n3] == 'a') {
            return AltarIconS.getImage();
        }
        if (this.map[n][n2][n3] == 'f') {
            return FountainIconS.getImage();
        }
        if (this.map[n][n2][n3] == 'p') {
            return PitIconS.getImage();
        }
        if (this.map[n][n2][n3] == 'l') {
            return LauncherIconS.getImage();
        }
        if (this.map[n][n2][n3] == 'm') {
            return MirrorIconS.getImage();
        }
        if (this.map[n][n2][n3] == 'g') {
            return GeneratorIconS.getImage();
        }
        if (this.map[n][n2][n3] == 'w') {
            return WritingIconS.getImage();
        }
        if (this.map[n][n2][n3] == '}') {
            return SconceIconS.getImage();
        }
        if (this.map[n][n2][n3] == 'D') {
            return DecorationIconS.getImage();
        }
        if (this.map[n][n2][n3] == 'F') {
            return FDecorationIconS.getImage();
        }
        if (this.map[n][n2][n3] == 'P') {
            return PillarIconS.getImage();
        }
        if (this.map[n][n2][n3] == 'i') {
            return InvisibleWallIconS.getImage();
        }
        if (this.map[n][n2][n3] == 'E') {
            return EventIconS.getImage();
        }
        if (this.map[n][n2][n3] == '!') {
            return StormIconS.getImage();
        }
        if (this.map[n][n2][n3] == 'G') {
            return GemIconS.getImage();
        }
        if (this.map[n][n2][n3] == 'y') {
            return FulYaIconS.getImage();
        }
        return null;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        dmnew.mappane.setVisible(false);
        dmnew.toppanel.setVisible(true);
        dmnew.centerpanel.setVisible(true);
        if (dmnew.sheet && SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.dm.showCenter(dmnew.dview);
            dmnew.sheet = false;
        }
        this.dm.validate();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }
}

