/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

class DoorData
extends MapData {
    public boolean isOpen;
    public boolean isBroken;
    public boolean isBreakable;
    public boolean resetcount;
    public int breakpoints;
    public int picklock;
    public int changecount = 4;
    public MapPoint xy;
    public int side;
    public boolean isclosing = true;
    public int opentype;
    public int pictype;
    public int keynumber;
    public boolean consumeskey;
    public boolean transparent;
    public int count;
    public int maxcount;
    public String custompic;

    public DoorData(MapPoint mapPoint, int n, int n2, int n3, boolean bl, boolean bl2, boolean bl3, int n4, boolean bl4, int n5, int n6, boolean bl5, int n7) {
        this.mapchar = (char)100;
        this.xy = mapPoint;
        this.side = n;
        this.pictype = n2;
        this.opentype = n3;
        this.keynumber = n4;
        this.consumeskey = bl4;
        this.maxcount = n5;
        this.count = n6;
        this.resetcount = bl5;
        this.picklock = n7;
        this.isOpen = bl;
        this.isBreakable = bl2;
        this.isBroken = bl3;
        this.canHoldItems = true;
        this.drawItems = true;
        if (this.isOpen) {
            this.drawFurtherItems = true;
            this.isPassable = true;
            this.canPassProjs = true;
            this.canPassMons = true;
            this.changecount = 0;
            this.isclosing = false;
        }
        if (this.pictype == 1) {
            this.canPassProjs = true;
            this.drawFurtherItems = true;
        }
    }

    @Override
    public void changeLevel(int n, int n2) {
        this.xy = new MapPoint(this.xy.level + n, this.xy.x, this.xy.y);
    }

    @Override
    public void setMapCoord(int n, int n2, int n3) {
        this.xy = new MapPoint(n, n2, n3);
    }

    @Override
    public String toString() {
        String string = this.isOpen ? "Open " : "Closed ";
        string = this.pictype == 0 ? string + "Wooden Door" : (this.pictype == 1 ? string + "Grate Door" : (this.pictype == 2 ? string + "Metal Door" : (this.pictype == 3 ? string + "Fancy Wooden Door" : (this.pictype == 4 ? string + "Fancy Metal Door" : (this.pictype == 5 ? string + "Black Door" : (this.pictype == 6 ? string + "Wooden Door w/Window" : (this.pictype == 7 ? string + "Black Door w/Window" : (this.pictype == 8 ? string + "Red Door" : (this.pictype == 9 ? string + "Ven Glass Door" : (this.pictype == 10 ? string + "Iron Cross Door" : (this.pictype == 11 ? string + "Iron Face Door" : string + "Custom Door")))))))))));
        if (this.isBroken) {
            string = string + " (Broken)";
        } else if (this.isBreakable) {
            string = string + " (Breakable)";
        }
        if (this.opentype == 1) {
            string = string + " (Button)";
        } else if (this.opentype == 2) {
            string = this.keynumber > 30 && this.keynumber < 47 ? string + " (Key - " + ItemWizard.keyitems[this.keynumber - 31] + ")" : string + " (Key)";
        }
        string = this.side == 0 ? string + " Facing North/South" : string + " Facing East/West";
        return string;
    }

    @Override
    public void save(ObjectOutputStream objectOutputStream) throws IOException {
        super.save(objectOutputStream);
        objectOutputStream.writeObject(this.xy);
        objectOutputStream.writeInt(this.side);
        objectOutputStream.writeInt(this.pictype);
        objectOutputStream.writeInt(this.opentype);
        objectOutputStream.writeBoolean(this.isOpen);
        objectOutputStream.writeBoolean(this.isBreakable);
        objectOutputStream.writeBoolean(this.isBroken);
        objectOutputStream.writeInt(this.keynumber);
        objectOutputStream.writeBoolean(this.consumeskey);
        objectOutputStream.writeInt(this.maxcount);
        objectOutputStream.writeInt(this.count);
        objectOutputStream.writeBoolean(this.resetcount);
        objectOutputStream.writeInt(this.picklock);
        objectOutputStream.writeInt(this.changecount);
        objectOutputStream.writeBoolean(this.isclosing);
        if (this.isBreakable && !this.isBroken) {
            objectOutputStream.writeInt(this.breakpoints);
        }
        if (this.pictype == 12) {
            objectOutputStream.writeUTF(this.custompic);
            objectOutputStream.writeBoolean(this.transparent);
        }
    }

    @Override
    public void load(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.changecount = objectInputStream.readInt();
        this.isclosing = objectInputStream.readBoolean();
        if (this.isBreakable && !this.isBroken) {
            this.breakpoints = objectInputStream.readInt();
        }
        if (this.pictype == 12) {
            this.custompic = objectInputStream.readUTF();
            this.transparent = objectInputStream.readBoolean();
        }
    }
}

