/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class EventSquareData
extends FloorData {
    public String[] eventtext;
    public Color textcolor;
    public Choice[] choices;
    public int eventface;
    public int picalign;
    public int textalign;
    public String picname;
    public String soundstring;
    public boolean blackback;
    public boolean loopsound;

    public EventSquareData(int n, String string, int n2, boolean bl, Color color, int n3, String[] stringArray, String string2, boolean bl2, Choice[] choiceArray) {
        this.eventface = n;
        this.picname = string;
        this.picalign = n2;
        this.blackback = bl;
        this.textcolor = color;
        this.textalign = n3;
        this.eventtext = stringArray;
        this.soundstring = string2;
        this.loopsound = bl2;
        this.choices = choiceArray;
        if (string.equals("")) {
            this.picname = null;
        }
        if (string2.equals("")) {
            this.soundstring = null;
            this.loopsound = false;
        }
        this.mapchar = (char)69;
    }

    public EventSquareData() {
        this.mapchar = (char)69;
    }

    @Override
    public String toString() {
        return "Event Square";
    }

    @Override
    public void changeLevel(int n, int n2) {
        for (int i = 0; i < this.choices.length; ++i) {
            for (int j = 0; j < this.choices[i].actions.size(); ++j) {
                Action action = (Action)this.choices[i].actions.get(j);
                if (action.actiontype <= 0 || action.actiontype >= 4) continue;
                MapPoint mapPoint = (MapPoint)action.action;
                if (mapPoint.level >= n2) {
                    mapPoint = new MapPoint(mapPoint.level + n, mapPoint.x, mapPoint.y);
                }
                if (mapPoint.level < 0) {
                    mapPoint = new MapPoint(0, mapPoint.x, mapPoint.y);
                }
                action.action = mapPoint;
            }
        }
    }

    @Override
    public void save(ObjectOutputStream objectOutputStream) throws IOException {
        super.save(objectOutputStream);
        objectOutputStream.writeInt(this.choices.length);
        if (this.choices.length > 0) {
            objectOutputStream.writeInt(this.eventface);
            if (this.picname != null) {
                objectOutputStream.writeBoolean(true);
                objectOutputStream.writeUTF(this.picname);
                objectOutputStream.writeInt(this.picalign);
            } else {
                objectOutputStream.writeBoolean(false);
            }
            objectOutputStream.writeBoolean(this.blackback);
            objectOutputStream.writeInt(this.textcolor.getRed());
            objectOutputStream.writeInt(this.textcolor.getGreen());
            objectOutputStream.writeInt(this.textcolor.getBlue());
            objectOutputStream.writeInt(this.textalign);
            objectOutputStream.writeObject(this.eventtext);
            if (this.soundstring != null) {
                objectOutputStream.writeBoolean(true);
                objectOutputStream.writeUTF(this.soundstring);
                objectOutputStream.writeBoolean(this.loopsound);
            } else {
                objectOutputStream.writeBoolean(false);
            }
            for (int i = 0; i < this.choices.length; ++i) {
                this.choices[i].save(objectOutputStream);
            }
        }
    }

    @Override
    public void load(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n = objectInputStream.readInt();
        if (n > 0) {
            this.eventface = objectInputStream.readInt();
            if (objectInputStream.readBoolean()) {
                this.picname = objectInputStream.readUTF();
                this.picalign = objectInputStream.readInt();
            }
            this.blackback = objectInputStream.readBoolean();
            this.textcolor = new Color(objectInputStream.readInt(), objectInputStream.readInt(), objectInputStream.readInt());
            this.textalign = objectInputStream.readInt();
            this.eventtext = (String[])objectInputStream.readObject();
            if (objectInputStream.readBoolean()) {
                this.soundstring = objectInputStream.readUTF();
                this.loopsound = objectInputStream.readBoolean();
            }
            this.choices = new Choice[n];
            for (int i = 0; i < n; ++i) {
                this.choices[i] = new Choice(objectInputStream.readUTF());
                this.choices[i].load(objectInputStream);
            }
        }
    }
}

