/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

class FloorSwitchData
extends FloorData {
    public MapPoint xy;
    public int type;
    public int targetlevel;
    public int targetx;
    public int targety;
    public boolean isReusable;
    public boolean wasUsed;
    public boolean playsound;
    public boolean haspic;
    public boolean switchstate;
    public int actiontype;
    public int delay;
    public int reset;
    public int changecount = 0;
    public boolean delaying;
    public boolean resetting;
    public boolean resetnotrigger;
    public MapData changeto;
    public MapData oldMapObject;
    public String soundstring;
    public int loopsound;
    public int switchface;
    public boolean abrupt;
    public boolean retainitems;

    public FloorSwitchData(MapPoint mapPoint, int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3, int n5, int n6, boolean bl4, int n7, MapData mapData, boolean bl5, int n8) {
        this.mapchar = (char)115;
        this.xy = mapPoint;
        this.type = n;
        this.targetlevel = n2;
        this.targetx = n3;
        this.targety = n4;
        this.isReusable = bl;
        this.haspic = bl2;
        this.playsound = bl3;
        this.delay = n5;
        this.reset = n6;
        this.resetnotrigger = bl4;
        this.actiontype = n7;
        this.changeto = mapData;
        this.retainitems = bl5;
        this.switchface = n8;
    }

    public FloorSwitchData() {
        this.mapchar = (char)115;
    }

    @Override
    public void changeLevel(int n, int n2) {
        if (this.targetlevel >= n2) {
            this.targetlevel += n;
        }
        if (this.targetlevel < 0) {
            this.targetlevel = 0;
        }
        this.xy = new MapPoint(this.xy.level + n, this.xy.x, this.xy.y);
    }

    @Override
    public void setMapCoord(int n, int n2, int n3) {
        this.xy = new MapPoint(n, n2, n3);
    }

    @Override
    public String toString() {
        return "FloorSwitch";
    }

    @Override
    public void save(ObjectOutputStream objectOutputStream) throws IOException {
        super.save(objectOutputStream);
        objectOutputStream.writeObject(this.xy);
        objectOutputStream.writeInt(this.type);
        objectOutputStream.writeInt(this.targetlevel);
        objectOutputStream.writeInt(this.targetx);
        objectOutputStream.writeInt(this.targety);
        objectOutputStream.writeBoolean(this.isReusable);
        objectOutputStream.writeInt(this.delay);
        objectOutputStream.writeInt(this.reset);
        objectOutputStream.writeBoolean(this.haspic);
        objectOutputStream.writeBoolean(this.playsound);
        objectOutputStream.writeInt(this.changecount);
        objectOutputStream.writeBoolean(this.delaying);
        objectOutputStream.writeBoolean(this.resetting);
        objectOutputStream.writeBoolean(this.resetnotrigger);
        objectOutputStream.writeBoolean(this.switchstate);
        objectOutputStream.writeInt(this.switchface);
        objectOutputStream.writeBoolean(this.wasUsed);
        objectOutputStream.writeInt(this.actiontype);
        if (this.actiontype == 5 || this.actiontype == 6) {
            this.changeto.save(objectOutputStream);
            if (this.switchstate && this.actiontype == 5) {
                this.oldMapObject.save(objectOutputStream);
            }
            objectOutputStream.writeBoolean(this.retainitems);
        } else if (this.actiontype == 7) {
            objectOutputStream.writeUTF(this.soundstring);
            objectOutputStream.writeInt(this.loopsound);
        } else if (this.actiontype == 8) {
            objectOutputStream.writeBoolean(this.abrupt);
        }
    }

    @Override
    public void load(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.xy = (MapPoint)objectInputStream.readObject();
        this.type = objectInputStream.readInt();
        this.targetlevel = objectInputStream.readInt();
        this.targetx = objectInputStream.readInt();
        this.targety = objectInputStream.readInt();
        this.isReusable = objectInputStream.readBoolean();
        this.delay = objectInputStream.readInt();
        this.reset = objectInputStream.readInt();
        this.haspic = objectInputStream.readBoolean();
        this.playsound = objectInputStream.readBoolean();
        this.changecount = objectInputStream.readInt();
        this.delaying = objectInputStream.readBoolean();
        this.resetting = objectInputStream.readBoolean();
        this.resetnotrigger = objectInputStream.readBoolean();
        this.switchstate = objectInputStream.readBoolean();
        this.switchface = objectInputStream.readInt();
        this.wasUsed = objectInputStream.readBoolean();
        this.actiontype = objectInputStream.readInt();
        if (this.actiontype == 5 || this.actiontype == 6) {
            this.changeto = DMEditor.loadMapData(objectInputStream, -1, 0, 0);
            if (this.switchstate && this.actiontype == 5) {
                this.oldMapObject = DMEditor.loadMapData(objectInputStream, -1, 0, 0);
            }
            this.retainitems = objectInputStream.readBoolean();
        } else if (this.actiontype == 7) {
            this.soundstring = objectInputStream.readUTF();
            this.loopsound = objectInputStream.readInt();
        } else if (this.actiontype == 8) {
            this.abrupt = objectInputStream.readBoolean();
        }
    }
}

