/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;

class FloorSwitchWizard
extends JDialog
implements ActionListener,
MouseListener {
    private MapData data;
    private MapData changeto;
    private int level;
    private int x;
    private int y;
    private int type = 0;
    private int changetype = 0;
    private int actiontype = 0;
    private JList itemlist;
    private int itemindex = -1;
    private ArrayList mapitems = new ArrayList(4);
    private Vector itemnames = new Vector(2);
    private JPanel typepanel;
    private JPanel newsquarepan;
    private JPanel soundpan;
    private JPanel itempanel;
    private JPanel bottom;
    private JLabel newsquare;
    private JTextField reset;
    private JTextField delay;
    private JTextField targetlevel;
    private JTextField targetx;
    private JTextField targety;
    private JTextField soundstring;
    private JToggleButton[] typebut = new JToggleButton[14];
    private JToggleButton togbut;
    private JToggleButton actbut;
    private JToggleButton deactbut;
    private JToggleButton actdeactbut;
    private JToggleButton deactactbut;
    private JToggleButton swapbut;
    private JToggleButton settobut;
    private JToggleButton soundbut;
    private JToggleButton nosoundbut;
    private JToggleButton abrupt;
    private JToggleButton isReusable;
    private JToggleButton isVisible;
    private JToggleButton makesSound;
    private JToggleButton additembut;
    private JToggleButton nomonsbut;
    private JToggleButton noghostsbut;
    private JToggleButton retainitems;
    private JToggleButton resetnotrigger;
    private JComboBox loopsound;
    private JComboBox switchface;
    private DMEditor dmed;
    public static final String[] corners = new String[]{"NW", "NE", "SE", "SW"};
    public static final String[] sides = new String[]{"N", "W", "S", "E"};
    public static final String[] facings = new String[]{"Any", "North", "West", "South", "East"};

    public FloorSwitchWizard(DMEditor dMEditor, MapData mapData, int n, int n2, int n3) {
        super(dMEditor, "Floor Switch Wizard", true);
        this.dmed = dMEditor;
        this.level = n;
        this.x = n2;
        this.y = n3;
        this.setDefaultCloseOperation(2);
        this.setSize(690, 550);
        this.setLocationRelativeTo(dMEditor);
        Container container = this.getContentPane();
        this.typepanel = new JPanel();
        this.typepanel.setLayout(new GridLayout(8, 2));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.typebut[0] = new JToggleButton("Always Triggers");
        this.typebut[1] = new JToggleButton("Constant Weight");
        this.typebut[2] = new JToggleButton("Party/Mons Only");
        this.typebut[3] = new JToggleButton("Items Only");
        this.typebut[4] = new JToggleButton("Stepping On Only");
        this.typebut[5] = new JToggleButton("Stepping Off Only");
        this.typebut[6] = new JToggleButton("Monsters Only");
        this.typebut[7] = new JToggleButton("Monsters Stepping On");
        this.typebut[8] = new JToggleButton("Monsters Stepping Off");
        this.typebut[9] = new JToggleButton("Party Only");
        this.typebut[10] = new JToggleButton("Party Stepping On");
        this.typebut[11] = new JToggleButton("Party Stepping Off");
        this.typebut[12] = new JToggleButton("Constant On Only");
        this.typebut[13] = new JToggleButton("Constant Off Only");
        for (int i = 0; i < 14; ++i) {
            this.typebut[i].setActionCommand("" + i);
            this.typebut[i].addActionListener(this);
            buttonGroup.add(this.typebut[i]);
            this.typepanel.add(this.typebut[i]);
        }
        this.typebut[0].setSelected(true);
        this.typepanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Switch Type"));
        JPanel jPanel = new JPanel();
        this.switchface = new JComboBox<String>(facings);
        this.switchface.setSelectedIndex(0);
        jPanel.add(new JLabel("Direction Party Must Face To Trigger:"));
        jPanel.add(this.switchface);
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        ButtonGroup buttonGroup2 = new ButtonGroup();
        this.togbut = new JToggleButton("Toggles");
        this.actbut = new JToggleButton("Activates");
        this.deactbut = new JToggleButton("Deactivates");
        this.actdeactbut = new JToggleButton("Act/Deact");
        this.deactactbut = new JToggleButton("Deact/Act");
        this.swapbut = new JToggleButton("Exchanges");
        this.settobut = new JToggleButton("Set To");
        this.soundbut = new JToggleButton("Play Sound");
        this.nosoundbut = new JToggleButton("Stop Sounds");
        this.togbut.addActionListener(this);
        this.actbut.addActionListener(this);
        this.deactbut.addActionListener(this);
        this.actdeactbut.addActionListener(this);
        this.deactactbut.addActionListener(this);
        this.swapbut.addActionListener(this);
        this.settobut.addActionListener(this);
        this.soundbut.addActionListener(this);
        this.nosoundbut.addActionListener(this);
        buttonGroup2.add(this.togbut);
        buttonGroup2.add(this.actbut);
        buttonGroup2.add(this.deactbut);
        buttonGroup2.add(this.actdeactbut);
        buttonGroup2.add(this.deactactbut);
        buttonGroup2.add(this.swapbut);
        buttonGroup2.add(this.settobut);
        buttonGroup2.add(this.soundbut);
        buttonGroup2.add(this.nosoundbut);
        jPanel2.add(this.togbut);
        jPanel2.add(this.actbut);
        jPanel2.add(this.deactbut);
        jPanel2.add(this.actdeactbut);
        jPanel3.add(this.deactactbut);
        jPanel3.add(this.swapbut);
        jPanel3.add(this.settobut);
        jPanel3.add(this.soundbut);
        jPanel3.add(this.nosoundbut);
        this.togbut.setSelected(true);
        this.newsquarepan = new JPanel();
        this.changeto = new FloorData();
        this.newsquare = new JLabel("Floor");
        this.newsquare.setPreferredSize(new Dimension(180, 15));
        JButton jButton = new JButton("Change");
        Font font = jButton.getFont().deriveFont(9.0f);
        this.nomonsbut = new JToggleButton("No Mons");
        this.noghostsbut = new JToggleButton("No Ghosts");
        this.retainitems = new JToggleButton("Retain Items");
        this.additembut = new JToggleButton("Items...");
        jButton.setFont(font);
        this.nomonsbut.setFont(font);
        this.noghostsbut.setFont(font);
        this.retainitems.setFont(font);
        this.additembut.setFont(font);
        jButton.setActionCommand("Change Square");
        jButton.addActionListener(this);
        this.nomonsbut.addActionListener(this);
        this.noghostsbut.addActionListener(this);
        this.additembut.addActionListener(this);
        this.newsquarepan.add(new JLabel("Replace With: "));
        this.newsquarepan.add(this.newsquare);
        this.newsquarepan.add(jButton);
        this.newsquarepan.add(this.nomonsbut);
        this.newsquarepan.add(this.noghostsbut);
        this.newsquarepan.add(this.retainitems);
        this.newsquarepan.add(this.additembut);
        this.newsquarepan.setVisible(false);
        this.soundpan = new JPanel();
        this.soundstring = new JTextField("switch.wav", 20);
        String[] stringArray = new String[]{"No Loop", "Loop - Delay", "Loop - No Delay"};
        this.loopsound = new JComboBox<String>(stringArray);
        this.soundpan.add(new JLabel("Sound To Play:"));
        this.soundpan.add(this.soundstring);
        JButton jButton2 = new JButton("Browse");
        jButton2.addActionListener(this);
        this.soundpan.add(jButton2);
        this.soundpan.add(this.loopsound);
        this.soundpan.setVisible(false);
        this.abrupt = new JToggleButton("Abrupt Cut-Off");
        this.abrupt.setVisible(false);
        this.itempanel = new JPanel();
        this.itemlist = new JList();
        this.itemlist.setSelectionMode(0);
        this.itemlist.setVisibleRowCount(6);
        this.itemlist.addMouseListener(this);
        Box box = Box.createVerticalBox();
        JScrollPane jScrollPane = new JScrollPane(this.itemlist);
        jScrollPane.setPreferredSize(new Dimension(180, 120));
        box.add(Box.createVerticalStrut(20));
        box.add(new JLabel("New Square's Items:"));
        box.add(jScrollPane);
        Box box2 = Box.createVerticalBox();
        JButton jButton3 = new JButton("Add/Edit Item");
        JButton jButton4 = new JButton("Remove Item");
        JButton jButton5 = new JButton("Change Side/Corner");
        jButton3.setFont(font);
        jButton4.setFont(font);
        jButton5.setFont(font);
        jButton3.addActionListener(this);
        jButton4.addActionListener(this);
        jButton5.addActionListener(this);
        box2.add(Box.createVerticalStrut(20));
        box2.add(jButton3);
        box2.add(jButton4);
        box2.add(jButton5);
        this.itempanel.add(box);
        this.itempanel.add(box2);
        this.itempanel.setVisible(false);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        Dimension dimension = new Dimension(340, 220);
        this.typepanel.setPreferredSize(dimension);
        this.typepanel.setMinimumSize(dimension);
        this.typepanel.setMaximumSize(dimension);
        jPanel4.add(this.typepanel);
        jPanel4.add(this.itempanel);
        jPanel4.add(jPanel);
        Box box3 = Box.createVerticalBox();
        Box box4 = Box.createVerticalBox();
        JLabel jLabel = new JLabel(" Level ");
        JLabel jLabel2 = new JLabel("    X");
        JLabel jLabel3 = new JLabel("    Y");
        jLabel2.setHorizontalAlignment(0);
        jLabel3.setHorizontalAlignment(0);
        this.targetlevel = new JTextField("" + n, 3);
        this.targetx = new JTextField("" + n2, 3);
        this.targety = new JTextField("" + n3, 3);
        box3.add(jLabel);
        box3.add(Box.createVerticalStrut(14));
        box3.add(jLabel2);
        box3.add(Box.createVerticalStrut(15));
        box3.add(jLabel3);
        box4.add(this.targetlevel);
        box4.add(Box.createVerticalStrut(10));
        box4.add(this.targetx);
        box4.add(Box.createVerticalStrut(10));
        box4.add(this.targety);
        Box box5 = Box.createHorizontalBox();
        box5.add(box3);
        box5.add(Box.createHorizontalStrut(5));
        box5.add(box4);
        JButton jButton6 = new JButton("From Map...");
        jButton6.addActionListener(this);
        JPanel jPanel5 = new JPanel();
        jPanel5.setPreferredSize(new Dimension(120, 140));
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        jPanel5.add(box5);
        jPanel5.add(Box.createVerticalStrut(10));
        jPanel5.add(jButton6);
        jPanel5.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Target"));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridLayout(3, 1));
        this.isReusable = new JToggleButton("Reusable");
        this.isVisible = new JToggleButton("Visible");
        this.makesSound = new JToggleButton("Makes Sound");
        jPanel6.add(this.isReusable);
        jPanel6.add(this.isVisible);
        jPanel6.add(this.makesSound);
        this.isReusable.setSelected(true);
        this.isVisible.setSelected(true);
        this.makesSound.setSelected(true);
        Box box6 = Box.createVerticalBox();
        box6.add(Box.createVerticalStrut(40));
        box6.add(jPanel5);
        box6.add(Box.createVerticalStrut(10));
        box6.add(jPanel6);
        box6.add(Box.createVerticalStrut(60));
        box6.add(Box.createVerticalGlue());
        this.bottom = new JPanel();
        this.bottom.setLayout(new BoxLayout(this.bottom, 1));
        this.bottom.add(jPanel2);
        this.bottom.add(jPanel3);
        this.bottom.add(this.newsquarepan);
        this.bottom.add(this.soundpan);
        this.bottom.add(this.abrupt);
        JPanel jPanel7 = new JPanel();
        this.reset = new JTextField("0", 4);
        this.delay = new JTextField("0", 4);
        jPanel7.add(new JLabel("Reset Count (0 for none):"));
        jPanel7.add(this.reset);
        jPanel7.add(new JLabel("Delay Count (0 for none):"));
        jPanel7.add(this.delay);
        this.resetnotrigger = new JToggleButton("No Trigger on Reset");
        jPanel7.add(this.resetnotrigger);
        this.bottom.add(jPanel7);
        JPanel jPanel8 = new JPanel();
        JButton jButton7 = new JButton("Done");
        JButton jButton8 = new JButton("Cancel");
        jButton7.addActionListener(this);
        jButton8.addActionListener(this);
        jPanel8.add(jButton8);
        jPanel8.add(jButton7);
        this.bottom.add(jPanel8);
        if (mapData != null && mapData.mapchar == 's') {
            FloorSwitchData floorSwitchData = (FloorSwitchData)mapData;
            this.typebut[floorSwitchData.type].doClick();
            this.targetlevel.setText("" + floorSwitchData.targetlevel);
            this.targetx.setText("" + floorSwitchData.targetx);
            this.targety.setText("" + floorSwitchData.targety);
            if (!floorSwitchData.isReusable) {
                this.isReusable.setSelected(false);
            }
            if (!floorSwitchData.haspic) {
                this.isVisible.setSelected(false);
            }
            if (!floorSwitchData.playsound) {
                this.makesSound.setSelected(false);
            }
            this.switchface.setSelectedIndex(floorSwitchData.switchface);
            if (floorSwitchData.actiontype == 1) {
                this.actbut.doClick();
            } else if (floorSwitchData.actiontype == 2) {
                this.deactbut.doClick();
            } else if (floorSwitchData.actiontype == 3) {
                this.actdeactbut.doClick();
            } else if (floorSwitchData.actiontype == 4) {
                this.deactactbut.doClick();
            } else if (floorSwitchData.actiontype == 7) {
                this.soundbut.doClick();
                this.soundstring.setText(floorSwitchData.soundstring);
                if (floorSwitchData.loopsound == 0) {
                    this.loopsound.setSelectedIndex(0);
                }
                if (floorSwitchData.loopsound < 0) {
                    this.loopsound.setSelectedIndex(2);
                } else {
                    this.loopsound.setSelectedIndex(1);
                }
            } else if (floorSwitchData.actiontype == 8) {
                this.nosoundbut.doClick();
                this.abrupt.setSelected(floorSwitchData.abrupt);
            } else if (floorSwitchData.actiontype >= 5) {
                this.changeto = floorSwitchData.changeto;
                switch (this.changeto.mapchar) {
                    case '0': {
                        this.changetype = 0;
                        break;
                    }
                    case '1': {
                        this.changetype = 1;
                        this.additembut.setEnabled(false);
                        this.nomonsbut.setEnabled(false);
                        break;
                    }
                    case '2': {
                        this.changetype = 2;
                        break;
                    }
                    case 'w': {
                        this.changetype = 3;
                        this.additembut.setEnabled(false);
                        this.nomonsbut.setEnabled(false);
                        break;
                    }
                    case '[': 
                    case ']': 
                    case 'a': {
                        this.changetype = 4;
                        this.nomonsbut.setEnabled(false);
                        break;
                    }
                    case 'm': {
                        this.changetype = 5;
                        this.additembut.setEnabled(false);
                        this.nomonsbut.setEnabled(false);
                        break;
                    }
                    case 'f': {
                        this.changetype = 6;
                        this.nomonsbut.setEnabled(false);
                        break;
                    }
                    case '}': {
                        this.changetype = 7;
                        this.additembut.setEnabled(false);
                        this.nomonsbut.setEnabled(false);
                        break;
                    }
                    case 'P': {
                        this.changetype = 8;
                        this.additembut.setEnabled(false);
                        this.nomonsbut.setEnabled(false);
                        break;
                    }
                    case 'd': {
                        this.changetype = 9;
                        break;
                    }
                    case 't': {
                        this.changetype = 10;
                        break;
                    }
                    case 'p': {
                        this.changetype = 11;
                        break;
                    }
                    case 'l': {
                        this.changetype = 12;
                        this.additembut.setEnabled(false);
                        this.nomonsbut.setEnabled(false);
                        break;
                    }
                    case 'g': {
                        this.changetype = 13;
                        break;
                    }
                    case 's': {
                        this.changetype = 14;
                        break;
                    }
                    case '/': {
                        this.changetype = 15;
                        this.additembut.setEnabled(false);
                        this.nomonsbut.setEnabled(false);
                        break;
                    }
                    case 'S': {
                        this.changetype = 16;
                        break;
                    }
                    case '\\': {
                        this.changetype = 17;
                        this.additembut.setEnabled(false);
                        this.nomonsbut.setEnabled(false);
                        break;
                    }
                    case 'D': {
                        this.changetype = 18;
                        this.additembut.setEnabled(false);
                        this.nomonsbut.setEnabled(false);
                        break;
                    }
                    case 'F': {
                        this.changetype = 19;
                        break;
                    }
                    case 'i': {
                        this.changetype = 20;
                        this.additembut.setEnabled(false);
                        this.nomonsbut.setEnabled(false);
                        break;
                    }
                    case '>': {
                        this.changetype = ((StairsData)this.changeto).goesUp ? 21 : 22;
                        this.additembut.setEnabled(false);
                        break;
                    }
                    case '!': {
                        this.changetype = 23;
                        this.additembut.setEnabled(false);
                        this.nomonsbut.setEnabled(false);
                        this.noghostsbut.setEnabled(false);
                        break;
                    }
                    case 'G': {
                        this.changetype = 24;
                        this.additembut.setEnabled(false);
                        this.nomonsbut.setEnabled(false);
                        this.noghostsbut.setEnabled(false);
                        break;
                    }
                    case 'y': {
                        this.changetype = 25;
                        this.additembut.setEnabled(false);
                        break;
                    }
                    case 'W': {
                        this.changetype = 26;
                        break;
                    }
                    case 'E': {
                        this.changetype = 27;
                    }
                }
                this.newsquare.setText(this.changeto.toString());
                this.retainitems.setSelected(floorSwitchData.retainitems);
                this.retainitems.setEnabled(this.changeto.canHoldItems);
                if (floorSwitchData.actiontype == 5) {
                    this.swapbut.doClick();
                } else {
                    this.settobut.doClick();
                }
                if (!this.changeto.canPassMons && this.nomonsbut.isEnabled()) {
                    this.nomonsbut.setSelected(true);
                    this.noghostsbut.setSelected(true);
                    this.noghostsbut.setEnabled(false);
                } else if (!this.changeto.canPassImmaterial && this.noghostsbut.isEnabled()) {
                    this.noghostsbut.setSelected(true);
                }
                if (floorSwitchData.changeto.hasItems && (floorSwitchData.changeto.mapchar == ']' || floorSwitchData.changeto.mapchar == 'a' || floorSwitchData.changeto.mapchar == 'f')) {
                    String string = " (" + sides[(((SidedWallData)floorSwitchData.changeto).side + 2) % 4] + ")";
                    for (int i = 0; i < floorSwitchData.changeto.mapItems.size(); ++i) {
                        Item item = (Item)floorSwitchData.changeto.mapItems.get(i);
                        this.mapitems.add(item);
                        this.itemnames.add(item.name + string);
                    }
                    this.itemlist.setListData(this.itemnames);
                } else if (floorSwitchData.changeto.mapchar == '[') {
                    int n4;
                    AlcoveData alcoveData = (AlcoveData)floorSwitchData.changeto;
                    for (n4 = 0; n4 < alcoveData.northside.size(); ++n4) {
                        this.mapitems.add(alcoveData.northside.get(n4));
                        this.itemnames.add(((Item)alcoveData.northside.get((int)n4)).name + " (N)");
                    }
                    for (n4 = 0; n4 < alcoveData.westside.size(); ++n4) {
                        this.mapitems.add(alcoveData.westside.get(n4));
                        this.itemnames.add(((Item)alcoveData.westside.get((int)n4)).name + " (W)");
                    }
                    for (n4 = 0; n4 < alcoveData.southside.size(); ++n4) {
                        this.mapitems.add(alcoveData.southside.get(n4));
                        this.itemnames.add(((Item)alcoveData.southside.get((int)n4)).name + " (S)");
                    }
                    for (n4 = 0; n4 < alcoveData.eastside.size(); ++n4) {
                        this.mapitems.add(alcoveData.eastside.get(n4));
                        this.itemnames.add(((Item)alcoveData.eastside.get((int)n4)).name + " (E)");
                    }
                    this.itemlist.setListData(this.itemnames);
                } else if (floorSwitchData.changeto.hasItems) {
                    for (int i = 0; i < floorSwitchData.changeto.mapItems.size(); ++i) {
                        Item item = (Item)floorSwitchData.changeto.mapItems.get(i);
                        this.mapitems.add(item);
                        this.itemnames.add(item.name + " (" + corners[item.subsquare] + ")");
                    }
                    this.itemlist.setListData(this.itemnames);
                }
            }
            this.delay.setText("" + floorSwitchData.delay);
            this.reset.setText("" + floorSwitchData.reset);
            this.resetnotrigger.setSelected(floorSwitchData.resetnotrigger);
        }
        container.add("West", jPanel4);
        container.add("East", box6);
        container.add("South", this.bottom);
        this.show();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Done")) {
            if (this.changeto.hasItems) {
                this.changeto.mapItems.clear();
            }
            if (this.actiontype >= 5 && this.actiontype < 7) {
                if (this.mapitems.size() > 0) {
                    if (this.changeto.mapchar == '[') {
                        AlcoveData alcoveData = (AlcoveData)this.changeto;
                        alcoveData.northside.clear();
                        alcoveData.westside.clear();
                        alcoveData.southside.clear();
                        alcoveData.eastside.clear();
                        for (int i = 0; i < this.mapitems.size(); ++i) {
                            Item item = (Item)this.mapitems.get(i);
                            alcoveData.addItem(item, item.subsquare);
                        }
                    } else {
                        for (int i = 0; i < this.mapitems.size(); ++i) {
                            Item item = (Item)this.mapitems.get(i);
                            this.changeto.addItem(item);
                        }
                    }
                }
                this.changeto.setMapCoord(Integer.parseInt(this.targetlevel.getText()), Integer.parseInt(this.targetx.getText()), Integer.parseInt(this.targety.getText()));
            } else {
                this.changeto = null;
            }
            this.data = new FloorSwitchData(new MapPoint(this.level, this.x, this.y), this.type, Integer.parseInt(this.targetlevel.getText()), Integer.parseInt(this.targetx.getText()), Integer.parseInt(this.targety.getText()), this.isReusable.isSelected(), this.isVisible.isSelected(), this.makesSound.isSelected(), Integer.parseInt(this.delay.getText()), Integer.parseInt(this.reset.getText()), this.resetnotrigger.isSelected(), this.actiontype, this.changeto, this.retainitems.isSelected(), this.switchface.getSelectedIndex());
            if (this.actiontype == 7) {
                ((FloorSwitchData)this.data).soundstring = this.soundstring.getText();
                if (this.loopsound.getSelectedIndex() == 1) {
                    ((FloorSwitchData)this.data).loopsound = 1;
                } else if (this.loopsound.getSelectedIndex() == 2) {
                    ((FloorSwitchData)this.data).loopsound = -1;
                }
            } else if (this.actiontype == 8) {
                ((FloorSwitchData)this.data).abrupt = this.abrupt.isSelected();
            }
            this.dispose();
        } else if (actionEvent.getActionCommand().equals("Cancel")) {
            this.data = null;
            this.dispose();
        } else if (actionEvent.getActionCommand().equals("From Map...")) {
            DMEditor.targetframe.show();
            MapPoint mapPoint = DMEditor.targetframe.getTarget();
            if (mapPoint != null) {
                this.targetlevel.setText("" + mapPoint.level);
                this.targetx.setText("" + mapPoint.x);
                this.targety.setText("" + mapPoint.y);
            }
        } else if (actionEvent.getActionCommand().equals("Toggles")) {
            this.newsquarepan.setVisible(false);
            this.soundpan.setVisible(false);
            this.abrupt.setVisible(false);
            this.actiontype = 0;
            if (this.itempanel.isVisible()) {
                this.itempanel.setVisible(false);
                this.typepanel.setVisible(true);
                this.additembut.setSelected(false);
            }
        } else if (actionEvent.getActionCommand().equals("Activates")) {
            this.newsquarepan.setVisible(false);
            this.soundpan.setVisible(false);
            this.abrupt.setVisible(false);
            this.actiontype = 1;
            if (this.itempanel.isVisible()) {
                this.itempanel.setVisible(false);
                this.typepanel.setVisible(true);
                this.additembut.setSelected(false);
            }
        } else if (actionEvent.getActionCommand().equals("Deactivates")) {
            this.newsquarepan.setVisible(false);
            this.soundpan.setVisible(false);
            this.abrupt.setVisible(false);
            this.actiontype = 2;
            if (this.itempanel.isVisible()) {
                this.itempanel.setVisible(false);
                this.typepanel.setVisible(true);
                this.additembut.setSelected(false);
            }
        } else if (actionEvent.getActionCommand().equals("Act/Deact")) {
            this.newsquarepan.setVisible(false);
            this.soundpan.setVisible(false);
            this.abrupt.setVisible(false);
            this.actiontype = 3;
            if (this.itempanel.isVisible()) {
                this.itempanel.setVisible(false);
                this.typepanel.setVisible(true);
                this.additembut.setSelected(false);
            }
        } else if (actionEvent.getActionCommand().equals("Deact/Act")) {
            this.newsquarepan.setVisible(false);
            this.soundpan.setVisible(false);
            this.abrupt.setVisible(false);
            this.actiontype = 4;
            if (this.itempanel.isVisible()) {
                this.itempanel.setVisible(false);
                this.typepanel.setVisible(true);
                this.additembut.setSelected(false);
            }
        } else if (actionEvent.getActionCommand().equals("Exchanges")) {
            this.newsquarepan.setVisible(true);
            this.soundpan.setVisible(false);
            this.abrupt.setVisible(false);
            this.actiontype = 5;
        } else if (actionEvent.getActionCommand().equals("Set To")) {
            this.newsquarepan.setVisible(true);
            this.soundpan.setVisible(false);
            this.abrupt.setVisible(false);
            this.actiontype = 6;
        } else if (actionEvent.getActionCommand().equals("Play Sound")) {
            this.newsquarepan.setVisible(false);
            this.soundpan.setVisible(true);
            this.abrupt.setVisible(false);
            this.actiontype = 7;
        } else if (actionEvent.getActionCommand().equals("Stop Sounds")) {
            this.newsquarepan.setVisible(false);
            this.soundpan.setVisible(false);
            this.abrupt.setVisible(true);
            this.actiontype = 8;
        } else if (actionEvent.getActionCommand().equals("Change Square")) {
            String[] stringArray = new String[]{"Floor", "Wall", "False Wall", "Writing", "Alcove", "Mirror", "Fountain", "Sconce", "Pillar", "Door", "Teleport", "Pit", "Launcher", "Generator", "Floor Switch", "Wall Switch", "Multiple Floor Switch", "Multiple Wall Switch", "Wall Decoration", "Floor Decoration", "Invisible Wall", "Stairs Up", "Stairs Down", "Stormbringer", "Power Gem", "FulYa Pit", "Win Square", "Event Square"};
            Object[] objectArray = new Object[3];
            objectArray[2] = new JComboBox<String>(stringArray);
            objectArray[1] = "Cancel";
            objectArray[0] = "Ok";
            ((JComboBox)objectArray[2]).setSelectedIndex(this.changetype);
            int n = JOptionPane.showOptionDialog(this.dmed, "What Kind of Map Object?", "Specify Exchanged Object", -1, 1, null, objectArray, objectArray[0]);
            if (n == 1 || n == -1) {
                return;
            }
            MapData mapData = null;
            this.changetype = ((JComboBox)objectArray[2]).getSelectedIndex();
            boolean bl = this.additembut.isEnabled();
            boolean bl2 = this.nomonsbut.isEnabled();
            boolean bl3 = this.nomonsbut.isSelected();
            boolean bl4 = this.noghostsbut.isEnabled();
            boolean bl5 = this.noghostsbut.isSelected();
            this.additembut.setEnabled(true);
            this.nomonsbut.setEnabled(true);
            this.nomonsbut.setSelected(false);
            this.noghostsbut.setEnabled(true);
            this.noghostsbut.setSelected(false);
            switch (this.changetype) {
                case 0: {
                    mapData = this.changeto = new FloorData();
                    break;
                }
                case 1: {
                    this.changeto = new WallData();
                    if (this.additembut.isSelected()) {
                        this.additembut.doClick();
                    }
                    this.additembut.setEnabled(false);
                    this.nomonsbut.setEnabled(false);
                    mapData = this.changeto;
                    break;
                }
                case 2: {
                    mapData = this.changeto = new FakeWallData();
                    break;
                }
                case 3: {
                    DMEditor.writingwizard.setData(this.changeto);
                    mapData = DMEditor.writingwizard.getData();
                    if (mapData == null) break;
                    this.changeto = mapData;
                    if (this.additembut.isSelected()) {
                        this.additembut.doClick();
                    }
                    this.additembut.setEnabled(false);
                    this.nomonsbut.setEnabled(false);
                    break;
                }
                case 4: {
                    if (!DMEditor.alcovewizard.isVisible()) {
                        DMEditor.alcovewizard.setData(this.changeto, this.level, this.x, this.y);
                        mapData = DMEditor.alcovewizard.getData();
                    } else {
                        AlcoveWizard alcoveWizard = new AlcoveWizard(this.dmed);
                        alcoveWizard.setData(this.changeto, this.level, this.x, this.y);
                        mapData = alcoveWizard.getData();
                    }
                    if (mapData == null) break;
                    this.changeto = mapData;
                    this.nomonsbut.setEnabled(false);
                    break;
                }
                case 5: {
                    DMEditor.mirrorwizard.setData(this.changeto);
                    mapData = DMEditor.mirrorwizard.getData();
                    if (mapData == null) break;
                    this.changeto = mapData;
                    if (this.additembut.isSelected()) {
                        this.additembut.doClick();
                    }
                    this.additembut.setEnabled(false);
                    this.nomonsbut.setEnabled(false);
                    break;
                }
                case 6: {
                    if (!DMEditor.fountainwizard.isVisible()) {
                        DMEditor.fountainwizard.setData(this.changeto, this.level, this.x, this.y);
                        mapData = DMEditor.fountainwizard.getData();
                    } else {
                        FountainWizard fountainWizard = new FountainWizard(this.dmed);
                        fountainWizard.setData(this.changeto, this.level, this.x, this.y);
                        mapData = fountainWizard.getData();
                    }
                    if (mapData == null) break;
                    this.changeto = mapData;
                    this.nomonsbut.setEnabled(false);
                    break;
                }
                case 7: {
                    if (!DMEditor.sconcewizard.isVisible()) {
                        DMEditor.sconcewizard.setData(this.changeto, this.level, this.x, this.y);
                        mapData = DMEditor.sconcewizard.getData();
                    } else {
                        SconceWizard sconceWizard = new SconceWizard(this.dmed);
                        sconceWizard.setData(this.changeto, this.level, this.x, this.y);
                        mapData = sconceWizard.getData();
                    }
                    if (mapData == null) break;
                    this.changeto = mapData;
                    if (this.additembut.isSelected()) {
                        this.additembut.doClick();
                    }
                    this.additembut.setEnabled(false);
                    this.nomonsbut.setEnabled(false);
                    break;
                }
                case 8: {
                    DMEditor.pillarwizard.setData(this.changeto, (this.x + this.y) % 2 == 0);
                    mapData = DMEditor.pillarwizard.getData();
                    if (mapData == null) break;
                    this.changeto = mapData;
                    if (this.additembut.isSelected()) {
                        this.additembut.doClick();
                    }
                    this.additembut.setEnabled(false);
                    this.nomonsbut.setEnabled(false);
                    break;
                }
                case 9: {
                    DMEditor.doorwizard.setData(this.changeto, this.level, this.x, this.y);
                    mapData = DMEditor.doorwizard.getData();
                    if (mapData == null) break;
                    this.changeto = mapData;
                    break;
                }
                case 10: {
                    DMEditor.teleportwizard.setData(this.changeto, this.level, this.x, this.y);
                    mapData = DMEditor.teleportwizard.getData();
                    if (mapData == null) break;
                    this.changeto = mapData;
                    break;
                }
                case 11: {
                    DMEditor.pitwizard.setData(this.changeto, this.level, this.x, this.y);
                    mapData = DMEditor.pitwizard.getData();
                    if (mapData == null) break;
                    this.changeto = mapData;
                    break;
                }
                case 12: {
                    DMEditor.launcherwizard.setData(this.changeto, this.level, this.x, this.y);
                    mapData = DMEditor.launcherwizard.getData();
                    if (mapData == null) break;
                    this.changeto = mapData;
                    if (this.additembut.isSelected()) {
                        this.additembut.doClick();
                    }
                    this.additembut.setEnabled(false);
                    this.nomonsbut.setEnabled(false);
                    break;
                }
                case 13: {
                    DMEditor.generatorwizard.setData(this.changeto, this.level, this.x, this.y);
                    mapData = DMEditor.generatorwizard.getData();
                    if (mapData == null) break;
                    this.changeto = mapData;
                    break;
                }
                case 14: {
                    mapData = new FloorSwitchWizard(this.dmed, this.changeto, Integer.parseInt(this.targetlevel.getText()), Integer.parseInt(this.targetx.getText()), Integer.parseInt(this.targety.getText())).getData();
                    if (mapData == null) break;
                    this.changeto = mapData;
                    break;
                }
                case 15: {
                    mapData = new WallSwitchWizard(this.dmed, this.changeto, Integer.parseInt(this.targetlevel.getText()), Integer.parseInt(this.targetx.getText()), Integer.parseInt(this.targety.getText())).getData();
                    if (mapData == null) break;
                    this.changeto = mapData;
                    if (this.additembut.isSelected()) {
                        this.additembut.doClick();
                    }
                    this.additembut.setEnabled(false);
                    this.nomonsbut.setEnabled(false);
                    break;
                }
                case 16: {
                    mapData = new MultFloorSwitchWizard(this.dmed, this.changeto, Integer.parseInt(this.targetlevel.getText()), Integer.parseInt(this.targetx.getText()), Integer.parseInt(this.targety.getText())).getData();
                    if (mapData == null) break;
                    this.changeto = mapData;
                    break;
                }
                case 17: {
                    mapData = new MultWallSwitchWizard(this.dmed, this.changeto, Integer.parseInt(this.targetlevel.getText()), Integer.parseInt(this.targetx.getText()), Integer.parseInt(this.targety.getText())).getData();
                    if (mapData == null) break;
                    this.changeto = mapData;
                    if (this.additembut.isSelected()) {
                        this.additembut.doClick();
                    }
                    this.additembut.setEnabled(false);
                    this.nomonsbut.setEnabled(false);
                    break;
                }
                case 18: {
                    DMEditor.decorationwizard.setData(this.changeto);
                    mapData = DMEditor.decorationwizard.getData();
                    if (mapData == null) break;
                    this.changeto = mapData;
                    if (this.additembut.isSelected()) {
                        this.additembut.doClick();
                    }
                    this.additembut.setEnabled(false);
                    this.nomonsbut.setEnabled(false);
                    break;
                }
                case 19: {
                    DMEditor.fdecorationwizard.setData(this.changeto, this.level, this.x, this.y);
                    mapData = DMEditor.fdecorationwizard.getData();
                    if (mapData == null) break;
                    this.changeto = mapData;
                    break;
                }
                case 20: {
                    this.changeto = new InvisibleWallData();
                    if (this.additembut.isSelected()) {
                        this.additembut.doClick();
                    }
                    this.additembut.setEnabled(false);
                    this.nomonsbut.setEnabled(false);
                    mapData = this.changeto;
                    break;
                }
                case 21: {
                    int n2 = this.changeto.mapchar == '>' ? (((StairsData)this.changeto).side + 2) % 4 : 2;
                    int n3 = new MoverDialog(this.dmed, "Choose Stairs Direction", n2, false).getNewLocation();
                    if (n3 < 0) break;
                    this.changeto = new StairsData((n3 + 2) % 4, true);
                    this.additembut.setEnabled(false);
                    mapData = this.changeto;
                    break;
                }
                case 22: {
                    int n4 = this.changeto.mapchar == '>' ? (((StairsData)this.changeto).side + 2) % 4 : 2;
                    int n5 = new MoverDialog(this.dmed, "Choose Stairs Direction", n4, false).getNewLocation();
                    if (n5 < 0) break;
                    this.changeto = new StairsData((n5 + 2) % 4, false);
                    this.additembut.setEnabled(false);
                    mapData = this.changeto;
                    break;
                }
                case 23: {
                    this.changeto = new StormbringerData(false);
                    if (this.additembut.isSelected()) {
                        this.additembut.doClick();
                    }
                    this.additembut.setEnabled(false);
                    this.nomonsbut.setEnabled(false);
                    this.noghostsbut.setEnabled(false);
                    mapData = this.changeto;
                    break;
                }
                case 24: {
                    this.changeto = new PowerGemData(false);
                    if (this.additembut.isSelected()) {
                        this.additembut.doClick();
                    }
                    this.additembut.setEnabled(false);
                    this.nomonsbut.setEnabled(false);
                    this.noghostsbut.setEnabled(false);
                    mapData = this.changeto;
                    break;
                }
                case 25: {
                    mapData = new FulYaWizard(this.dmed, this.changeto, this.level, this.x, this.y).getData();
                    if (mapData == null) break;
                    this.changeto = mapData;
                    if (this.additembut.isSelected()) {
                        this.additembut.doClick();
                    }
                    this.additembut.setEnabled(false);
                    break;
                }
                case 26: {
                    mapData = new GameWinWizard(this.dmed, this.changeto).getData();
                    if (mapData == null) break;
                    this.changeto = mapData;
                    break;
                }
                case 27: {
                    DMEditor.eventwizard.setData(this.changeto);
                    mapData = DMEditor.eventwizard.getData();
                    if (mapData == null) break;
                    this.changeto = mapData;
                }
            }
            if (mapData == null) {
                this.additembut.setEnabled(bl);
                this.nomonsbut.setEnabled(bl2);
                this.nomonsbut.setSelected(bl3);
                this.noghostsbut.setEnabled(bl4);
                this.noghostsbut.setSelected(bl5);
                return;
            }
            this.newsquare.setText(this.changeto.toString());
            this.mapitems.clear();
            this.itemnames.clear();
            this.itemlist.setListData(this.itemnames);
            this.retainitems.setEnabled(this.changeto.canHoldItems);
            if (!this.changeto.canHoldItems) {
                this.retainitems.setSelected(false);
            }
        } else if (actionEvent.getActionCommand().equals("Browse")) {
            this.dmed.chooser.setCurrentDirectory(new File(this.dmed.workingdir, "Sounds"));
            int n = this.dmed.chooser.showOpenDialog(this);
            String string = null;
            if (n == 0) {
                string = this.dmed.chooser.getSelectedFile().getName();
            }
            if (string != null) {
                this.soundstring.setText(string);
            }
        } else if (actionEvent.getActionCommand().equals("No Mons")) {
            boolean bl = this.changeto.canPassMons = !this.changeto.canPassMons;
            if (!this.changeto.canPassMons) {
                this.noghostsbut.setSelected(true);
                this.noghostsbut.setEnabled(false);
            } else {
                this.noghostsbut.setEnabled(true);
            }
        } else if (actionEvent.getActionCommand().equals("No Ghosts")) {
            this.changeto.canPassImmaterial = !this.changeto.canPassImmaterial;
        } else if (actionEvent.getActionCommand().equals("Items...")) {
            if (!this.itempanel.isVisible()) {
                this.typepanel.setVisible(false);
                this.itempanel.setVisible(true);
                return;
            }
            this.itempanel.setVisible(false);
            this.typepanel.setVisible(true);
        } else if (actionEvent.getActionCommand().equals("Add/Edit Item")) {
            int n = this.itemlist.getSelectedIndex();
            if (n == -1) {
                DMEditor.itemwizard.setTitle("Item Wizard - Add An Item To The New Square");
                DMEditor.itemwizard.show();
                Item item = DMEditor.itemwizard.getItem();
                if (item == null) {
                    return;
                }
                item.subsquare = 0;
                this.mapitems.add(item);
                if (this.changeto.mapchar == '[') {
                    this.itemnames.add(item.name + " (N)");
                } else if (this.changeto.mapchar == 'a' || this.changeto.mapchar == ']' || this.changeto.mapchar == 'f') {
                    item.subsquare = (((SidedWallData)this.changeto).side + 2) % 4;
                    this.itemnames.add(item.name + " (" + sides[item.subsquare] + ")");
                } else {
                    this.itemnames.add(item.name + " (NW)");
                }
                this.itemlist.setListData(this.itemnames);
            } else {
                DMEditor.itemwizard.setTitle("Item Wizard - Change An Item On The New Square");
                DMEditor.itemwizard.setItem((Item)this.mapitems.get(n));
                Item item = DMEditor.itemwizard.getItem();
                if (item == null) {
                    this.itemlist.clearSelection();
                    this.itemindex = -1;
                    return;
                }
                item.subsquare = ((Item)this.mapitems.get((int)n)).subsquare;
                this.mapitems.set(n, item);
                if (this.changeto.mapchar == '[') {
                    this.itemnames.setElementAt(item.name + " (" + sides[item.subsquare] + ")", n);
                } else if (this.changeto.mapchar == 'a' || this.changeto.mapchar == ']' || this.changeto.mapchar == 'f') {
                    item.subsquare = (((SidedWallData)this.changeto).side + 2) % 4;
                    this.itemnames.setElementAt(item.name + " (" + sides[item.subsquare] + ")", n);
                } else {
                    this.itemnames.setElementAt(item.name + " (" + corners[item.subsquare] + ")", n);
                }
                this.itemlist.setListData(this.itemnames);
                this.itemindex = -1;
            }
        } else if (actionEvent.getActionCommand().equals("Remove Item")) {
            if (this.itemnames.size() == 0 || this.itemlist.isSelectionEmpty()) {
                return;
            }
            int n = this.itemlist.getSelectedIndex();
            this.mapitems.remove(n);
            this.itemnames.remove(n);
            this.itemlist.setListData(this.itemnames);
            this.itemindex = -1;
        } else if (actionEvent.getActionCommand().equals("Change Side/Corner")) {
            if (this.itemnames.size() == 0 || this.itemlist.isSelectionEmpty()) {
                return;
            }
            if (this.changeto.mapchar == 'a' || this.changeto.mapchar == ']') {
                this.itemlist.clearSelection();
                this.itemindex = -1;
                return;
            }
            int n = this.itemlist.getSelectedIndex();
            if (this.changeto.mapchar == '[') {
                int n6;
                Item item = (Item)this.mapitems.get(n);
                item.subsquare = n6 = JOptionPane.showOptionDialog(this.dmed, "Which side?", "Change Side", -1, 3, null, sides, sides[item.subsquare]);
                this.itemnames.setElementAt(item.name + " (" + sides[n6] + ")", n);
                this.itemlist.setListData(this.itemnames);
                this.itemindex = -1;
            } else {
                int n7;
                Item item = (Item)this.mapitems.get(n);
                item.subsquare = n7 = JOptionPane.showOptionDialog(this.dmed, "Which corner?", "Change Corner", -1, 3, null, corners, corners[item.subsquare]);
                this.itemnames.setElementAt(item.name + " (" + corners[n7] + ")", n);
                this.itemlist.setListData(this.itemnames);
                this.itemindex = -1;
            }
        } else {
            int n;
            try {
                n = Integer.parseInt(actionEvent.getActionCommand());
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            this.type = n;
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        int n = this.itemlist.locationToIndex(mouseEvent.getPoint());
        if (n == -1 || n == this.itemindex) {
            this.itemlist.clearSelection();
        }
        this.itemindex = this.itemlist.getSelectedIndex();
    }

    public MapData getData() {
        return this.data;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }
}

